/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\r\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0006\u0010(\u001a\u00020&J\u0006\u0010)\u001a\u00020&J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0003J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001e\u0010.\u001a\u00020\u00002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u00100\u001a\u0004\u0018\u00010\u000fJ\u0006\u00101\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001f\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "", "offset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "geomWithAxisBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomOuterBounds", "geomInnerBounds", "axisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "hAxisShown", "", "vAxisShown", "facetXLabels", "", "", "facetYLabel", "trueIndex", "", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;ZZLjava/util/List;Ljava/lang/String;I)V", "getAxisInfos", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "getFacetXLabels", "()Ljava/util/List;", "getFacetYLabel", "()Ljava/lang/String;", "getGeomInnerBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getGeomOuterBounds", "getGeomWithAxisBounds", "getHAxisShown", "()Z", "getOffset", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getTrueIndex", "()I", "getVAxisShown", "axisThicknessX", "", "axisThicknessY", "geomOuterHeight", "geomOuterWidth", "getAbsoluteBounds", "tilesOrigin", "getAbsoluteOuterGeomBounds", "withAxisShown", "withFacetLabels", "xLabels", "yLabel", "withNormalizedOrigin", "withOffset", "plot-builder"})
public final class TileLayoutInfo {
    @NotNull
    private final DoubleVector offset;
    @NotNull
    private final DoubleRectangle geomWithAxisBounds;
    @NotNull
    private final DoubleRectangle geomOuterBounds;
    @NotNull
    private final DoubleRectangle geomInnerBounds;
    @NotNull
    private final AxisLayoutInfoQuad axisInfos;
    @NotNull
    private final List<String> facetXLabels;
    @Nullable
    private final String facetYLabel;
    private final int trueIndex;
    private final boolean hAxisShown;
    private final boolean vAxisShown;

    public TileLayoutInfo(@NotNull DoubleVector offset, @NotNull DoubleRectangle geomWithAxisBounds, @NotNull DoubleRectangle geomOuterBounds, @NotNull DoubleRectangle geomInnerBounds, @NotNull AxisLayoutInfoQuad axisInfos, boolean hAxisShown, boolean vAxisShown, @NotNull List<String> facetXLabels, @Nullable String facetYLabel, int trueIndex) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)geomWithAxisBounds, (String)"geomWithAxisBounds");
        Intrinsics.checkNotNullParameter((Object)geomOuterBounds, (String)"geomOuterBounds");
        Intrinsics.checkNotNullParameter((Object)geomInnerBounds, (String)"geomInnerBounds");
        Intrinsics.checkNotNullParameter((Object)axisInfos, (String)"axisInfos");
        Intrinsics.checkNotNullParameter(facetXLabels, (String)"facetXLabels");
        this.offset = offset;
        this.geomWithAxisBounds = geomWithAxisBounds;
        this.geomOuterBounds = geomOuterBounds;
        this.geomInnerBounds = geomInnerBounds;
        this.axisInfos = axisInfos;
        this.facetXLabels = facetXLabels;
        this.facetYLabel = facetYLabel;
        this.trueIndex = trueIndex;
        this.hAxisShown = (this.axisInfos.getTop() != null || this.axisInfos.getBottom() != null) && hAxisShown;
        this.vAxisShown = (this.axisInfos.getLeft() != null || this.axisInfos.getRight() != null) && vAxisShown;
    }

    public /* synthetic */ TileLayoutInfo(DoubleVector doubleVector, DoubleRectangle doubleRectangle, DoubleRectangle doubleRectangle2, DoubleRectangle doubleRectangle3, AxisLayoutInfoQuad axisLayoutInfoQuad, boolean bl, boolean bl2, List list, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x80) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x100) != 0) {
            string = null;
        }
        this(doubleVector, doubleRectangle, doubleRectangle2, doubleRectangle3, axisLayoutInfoQuad, bl, bl2, list, string, n);
    }

    @NotNull
    public final DoubleVector getOffset() {
        return this.offset;
    }

    @NotNull
    public final DoubleRectangle getGeomWithAxisBounds() {
        return this.geomWithAxisBounds;
    }

    @NotNull
    public final DoubleRectangle getGeomOuterBounds() {
        return this.geomOuterBounds;
    }

    @NotNull
    public final DoubleRectangle getGeomInnerBounds() {
        return this.geomInnerBounds;
    }

    @NotNull
    public final AxisLayoutInfoQuad getAxisInfos() {
        return this.axisInfos;
    }

    @NotNull
    public final List<String> getFacetXLabels() {
        return this.facetXLabels;
    }

    @Nullable
    public final String getFacetYLabel() {
        return this.facetYLabel;
    }

    public final int getTrueIndex() {
        return this.trueIndex;
    }

    public final boolean getHAxisShown() {
        return this.hAxisShown;
    }

    public final boolean getVAxisShown() {
        return this.vAxisShown;
    }

    @NotNull
    public final DoubleRectangle getAbsoluteBounds(@NotNull DoubleVector tilesOrigin) {
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        DoubleVector offset = tilesOrigin.add(this.offset);
        return this.geomWithAxisBounds.add(offset);
    }

    @NotNull
    public final DoubleRectangle getAbsoluteOuterGeomBounds(@NotNull DoubleVector tilesOrigin) {
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        DoubleVector offset = tilesOrigin.add(this.offset);
        return this.geomOuterBounds.add(offset);
    }

    public final double axisThicknessX() {
        return this.geomWithAxisBounds.getBottom() - this.geomOuterBounds.getBottom();
    }

    public final double axisThicknessY() {
        return this.geomOuterBounds.getLeft() - this.geomWithAxisBounds.getLeft();
    }

    public final double geomOuterWidth() {
        return this.geomOuterBounds.getWidth();
    }

    public final double geomOuterHeight() {
        return this.geomOuterBounds.getHeight();
    }

    @NotNull
    public final TileLayoutInfo withOffset(@NotNull DoubleVector offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new TileLayoutInfo(offset, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withFacetLabels(@NotNull List<String> xLabels, @Nullable String yLabel) {
        Intrinsics.checkNotNullParameter(xLabels, (String)"xLabels");
        return new TileLayoutInfo(this.offset, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, xLabels, yLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withAxisShown(boolean hAxisShown, boolean vAxisShown) {
        return new TileLayoutInfo(this.offset, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.axisInfos, hAxisShown, vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withNormalizedOrigin() {
        DoubleVector geomWithAxisOrigin = this.geomWithAxisBounds.getOrigin();
        DoubleRectangle geomWithAxisBounds = this.geomWithAxisBounds.subtract(geomWithAxisOrigin);
        DoubleRectangle geomOuterBounds = this.geomOuterBounds.subtract(geomWithAxisOrigin);
        DoubleRectangle geomInnerBounds = this.geomInnerBounds.subtract(geomWithAxisOrigin);
        return new TileLayoutInfo(this.offset, geomWithAxisBounds, geomOuterBounds, geomInnerBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }
}

