/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FixedScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FreeScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "layoutProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "showFacetStrip", "", "hAxisOrientation", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisOrientation", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;Ljava/util/List;ZLorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "totalAddedHSize", "", "totalAddedVSize", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nFacetedPlotLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1#2:227\n288#3,2:228\n766#3:230\n857#3,2:231\n1655#3,8:233\n1747#3,3:241\n2661#3,7:244\n*S KotlinDebug\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n*L\n51#1:228,2\n53#1:230\n53#1:231,2\n54#1:233,8\n58#1:241,3\n161#1:244,7\n*E\n"})
public final class FacetedPlotLayout
implements PlotLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final List<TileLayoutProvider> layoutProviderByTile;
    private final boolean showFacetStrip;
    @NotNull
    private final AxisTheme hAxisTheme;
    @NotNull
    private final AxisTheme vAxisTheme;
    private final double totalAddedHSize;
    private final double totalAddedVSize;
    @NotNull
    private final Insets insets;
    public static final double FACET_TAB_HEIGHT = 30.0;
    public static final int FACET_H_PADDING = 0;
    public static final int FACET_V_PADDING = 6;
    private static final double PANEL_PADDING = 10.0;

    public FacetedPlotLayout(@NotNull PlotFacets facets, @NotNull List<? extends TileLayoutProvider> layoutProviderByTile, boolean showFacetStrip, @NotNull AxisPosition hAxisOrientation, @NotNull AxisPosition vAxisOrientation, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisOrientation), (String)"hAxisOrientation");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisOrientation), (String)"vAxisOrientation");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        this.facets = facets;
        this.layoutProviderByTile = layoutProviderByTile;
        this.showFacetStrip = showFacetStrip;
        this.hAxisTheme = hAxisTheme;
        this.vAxisTheme = vAxisTheme;
        this.totalAddedHSize = 10.0 * (double)(this.facets.getColCount() - 1);
        this.totalAddedVSize = 10.0 * (double)(this.facets.getRowCount() - 1);
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets(hAxisOrientation, vAxisOrientation, this.hAxisTheme, this.vAxisTheme);
        if (!this.facets.isDefined()) {
            boolean bl = false;
            String string = "Undefined facets.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void $this$reduce$iv;
        DoubleVector labsTotalDim;
        int $i$f$any22;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleVector tilesAreaSize = new DoubleVector(preferredSize.getX() - (this.insets.getLeft() + this.insets.getRight()), preferredSize.getY() - (this.insets.getTop() + this.insets.getBottom()));
        List<PlotFacets.FacetTileInfo> facetTiles = this.facets.tileInfos();
        if (this.showFacetStrip) {
            boolean bl;
            double totalAddedHeight;
            block12: {
                void $this$distinctBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object object;
                Object v1;
                Iterable $this$firstOrNull$iv;
                block11: {
                    $this$firstOrNull$iv = facetTiles;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = !((Collection)it.getColLabs()).isEmpty();
                        if (!bl3) continue;
                        v1 = element$iv;
                        break block11;
                    }
                    v1 = null;
                }
                int tileColLabCounts = (object = (PlotFacets.FacetTileInfo)v1) != null && (object = ((PlotFacets.FacetTileInfo)object).getColLabs()) != null ? object.size() : 0;
                $this$firstOrNull$iv = facetTiles;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)element$iv$iv;
                    boolean bl4 = false;
                    boolean bl5 = !((Collection)it.getColLabs()).isEmpty();
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$distinctBy = false;
                HashSet<Integer> set$iv = new HashSet<Integer>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)e$iv;
                    boolean bl6 = false;
                    Integer key$iv = it.getRow();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                int tileWithColLabInRowCount = ((Collection)list$iv).size();
                totalAddedHeight = Companion.facetColHeadHeight(tileColLabCounts) * (double)tileWithColLabInRowCount;
                Iterable $this$any$iv = facetTiles;
                $i$f$any22 = 0;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)element$iv;
                        boolean bl7 = false;
                        if (!(it.getRowLab() != null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            boolean labsInRow = bl;
            labsTotalDim = new DoubleVector((double)labsInRow * 30.0, totalAddedHeight);
            tilesAreaSize = tilesAreaSize.subtract(labsTotalDim);
        }
        List<TileLayoutInfo> layoutInfos = this.facets.getFreeHScale() || this.facets.getFreeVScale() ? FreeScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme) : FixedScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme);
        List<Double> geomOffsetByCol = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByCol(layoutInfos, facetTiles, 10.0, this.facets.getColCount());
        List<Double> geomOffsetByRow = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByRow(layoutInfos, facetTiles, this.showFacetStrip, 10.0, this.facets.getRowCount());
        ArrayList<DoubleRectangle> tileBoundsList = new ArrayList<DoubleRectangle>();
        ArrayList<DoubleRectangle> geomOuterBoundsList = new ArrayList<DoubleRectangle>();
        labsTotalDim = facetTiles.iterator();
        $i$f$any22 = 0;
        while (labsTotalDim.hasNext()) {
            int index = $i$f$any22++;
            PlotFacets.FacetTileInfo facetTile = labsTotalDim.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            int col = facetTile.getCol();
            int row = facetTile.getRow();
            double geomX = ((Number)geomOffsetByCol.get(col)).doubleValue();
            double geomY = ((Number)geomOffsetByRow.get(row)).doubleValue();
            DoubleVector outerGeomSize = layoutInfo.getGeomOuterBounds().getDimension();
            double tileLabelWidth = facetTile.getRowLab() != null && this.showFacetStrip ? 30.0 : 0.0;
            double axisWidth = facetTile.getHasVAxis() ? layoutInfo.axisThicknessY() : 0.0;
            double tileX = geomX - axisWidth;
            double tileWidth = outerGeomSize.getX() + axisWidth + tileLabelWidth;
            double tileLabelHeight = this.showFacetStrip ? Companion.facetColHeadHeight(facetTile.getColLabs().size()) : 0.0;
            double axisHeight = facetTile.getHasHAxis() ? layoutInfo.axisThicknessX() : 0.0;
            double tileY = geomY - tileLabelHeight;
            double tileHeight = outerGeomSize.getY() + tileLabelHeight + axisHeight;
            DoubleRectangle tileBounds = new DoubleRectangle(new DoubleVector(tileX, tileY), new DoubleVector(tileWidth, tileHeight));
            DoubleRectangle geomOuterBounds = new DoubleRectangle(new DoubleVector(geomX, geomY), outerGeomSize);
            tileBoundsList.add(tileBounds);
            geomOuterBoundsList.add(geomOuterBounds);
        }
        Iterable $i$f$any22 = tileBoundsList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b1;
            DoubleRectangle col = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle b0 = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = b0.union((DoubleRectangle)b1);
        }
        DoubleVector tilesAreaOrigin = ((DoubleRectangle)accumulator$iv).getOrigin();
        DoubleVector originDelta = tilesAreaOrigin.negate();
        DoubleVector tilesPaddingLeftTop = this.insets.getLeftTop();
        ArrayList<TileLayoutInfo> finalLayoutInfos = new ArrayList<TileLayoutInfo>();
        accumulator$iv = facetTiles.iterator();
        int n = 0;
        while (accumulator$iv.hasNext()) {
            int index = n++;
            PlotFacets.FacetTileInfo facetTile = (PlotFacets.FacetTileInfo)accumulator$iv.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            DoubleVector geomInnerBoundsOffset = layoutInfo.getGeomInnerBounds().getOrigin().subtract(layoutInfo.getGeomOuterBounds().getOrigin());
            Object e = tileBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"tileBoundsList[index]");
            DoubleRectangle tileBounds = (DoubleRectangle)e;
            Object e2 = geomOuterBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"geomOuterBoundsList[index]");
            DoubleRectangle geomOuterBounds = (DoubleRectangle)e2;
            DoubleRectangle geomInnerBounds = new DoubleRectangle(geomOuterBounds.getOrigin().add(geomInnerBoundsOffset), layoutInfo.getGeomInnerBounds().getDimension());
            TileLayoutInfo newLayoutInfo = new TileLayoutInfo(tilesPaddingLeftTop, tileBounds.add(originDelta), geomOuterBounds.add(originDelta), geomInnerBounds.add(originDelta), layoutInfo.getAxisInfos(), facetTile.getHasHAxis(), facetTile.getHasVAxis(), null, null, facetTile.getTrueIndex(), 384, null);
            finalLayoutInfos.add(this.showFacetStrip ? newLayoutInfo.withFacetLabels(facetTile.getColLabs(), facetTile.getRowLab()) : newLayoutInfo);
        }
        Insets plotInsets = new Insets(tilesPaddingLeftTop, this.insets.getRightBottom());
        return new PlotLayoutInfo((List<TileLayoutInfo>)finalLayoutInfos, plotInsets);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout$Companion;", "", "()V", "FACET_H_PADDING", "", "FACET_TAB_HEIGHT", "", "FACET_V_PADDING", "PANEL_PADDING", "facetColHeadHeight", "labCount", "facetColLabelSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "colWidth", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector facetColLabelSize(double colWidth) {
            return new DoubleVector(colWidth - 0.0, 18.0);
        }

        public final double facetColHeadHeight(int labCount) {
            return labCount > 0 ? this.facetColLabelSize(0.0).getY() * (double)labCount + (double)12 : 0.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

