/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBreak;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 32\u00020\u0001:\u000534567B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u001fH$J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0011H$R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000fR\u0010\u0010$\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u001f0&j\b\u0012\u0004\u0012\u00020\u001f`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u001f0&j\b\u0012\u0004\u0012\u00020\u001f`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0013\"\u0004\b+\u0010\u0015\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "getBreaks", "()Ljava/util/List;", "colCount", "", "getColCount", "()I", "setColCount", "(I)V", "graphSize", "getGraphSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isFillByRow", "", "()Z", "setFillByRow", "(Z)V", "keyLabelBoxes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getKeyLabelBoxes", "getKeySizes", "labelBoxes", "getLabelBoxes", "myContentSize", "myKeyLabelBoxes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myLabelBoxes", "rowCount", "getRowCount", "setRowCount", "breakBoxOrigin", "index", "prevBreakBoxBounds", "doLayout", "", "ensureInited", "labelSize", "Companion", "MyHorizontal", "MyHorizontalMultiRow", "MyMultiRow", "MyVertical", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nLegendComponentLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegendComponentLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
public abstract class LegendComponentLayout
extends LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LegendBreak> breaks;
    @NotNull
    private final List<DoubleVector> keySizes;
    @Nullable
    private DoubleVector myContentSize;
    @NotNull
    private final ArrayList<DoubleRectangle> myKeyLabelBoxes;
    @NotNull
    private final ArrayList<DoubleRectangle> myLabelBoxes;
    private boolean isFillByRow;
    private int rowCount;
    private int colCount;

    public LegendComponentLayout(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendDirection legendDirection, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
        Intrinsics.checkNotNullParameter((Object)legendDirection, (String)"legendDirection");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(title, legendDirection, theme);
        this.breaks = breaks;
        this.keySizes = keySizes;
        this.myKeyLabelBoxes = new ArrayList();
        this.myLabelBoxes = new ArrayList();
    }

    @NotNull
    protected final List<LegendBreak> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final List<DoubleVector> getKeySizes() {
        return this.keySizes;
    }

    public final boolean isFillByRow() {
        return this.isFillByRow;
    }

    public final void setFillByRow(boolean bl) {
        this.isFillByRow = bl;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final void setRowCount(int rowCount) {
        if (!(rowCount > 0)) {
            boolean bl = false;
            String string = "Row count must be greater than 0, was " + rowCount;
            throw new IllegalStateException(string.toString());
        }
        this.rowCount = rowCount;
    }

    public final int getColCount() {
        return this.colCount;
    }

    public final void setColCount(int colCount) {
        if (!(colCount > 0)) {
            boolean bl = false;
            String string = "Col count must be greater than 0, was " + colCount;
            throw new IllegalStateException(string.toString());
        }
        this.colCount = colCount;
    }

    @Override
    @NotNull
    public DoubleVector getGraphSize() {
        this.ensureInited();
        DoubleVector doubleVector = this.myContentSize;
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector;
    }

    @NotNull
    public final List<DoubleRectangle> getKeyLabelBoxes() {
        this.ensureInited();
        return this.myKeyLabelBoxes;
    }

    @NotNull
    public final List<DoubleRectangle> getLabelBoxes() {
        this.ensureInited();
        return this.myLabelBoxes;
    }

    private final void ensureInited() {
        if (this.myContentSize == null) {
            this.doLayout();
        }
    }

    private final void doLayout() {
        double labelLeftMargin = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).width("_") / (double)2;
        double intervalBetweenLabels = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height() / (double)3;
        DoubleVector contentOrigin = DoubleVector.Companion.getZERO();
        DoubleVector breakBoxBounds = null;
        int n = this.breaks.size();
        for (int i = 0; i < n; ++i) {
            DoubleVector doubleVector;
            DoubleVector breakBoxSize;
            double labelHOffset;
            double labelVOffset;
            DoubleVector labelSize;
            block4: {
                block3: {
                    labelSize = this.labelSize(i).add(new DoubleVector(0.0, intervalBetweenLabels));
                    DoubleVector keySize = this.keySizes.get(i);
                    double height = Math.max(keySize.getY(), labelSize.getY());
                    labelVOffset = keySize.getY() / (double)2;
                    labelHOffset = keySize.getX() + labelLeftMargin;
                    breakBoxSize = new DoubleVector(labelHOffset + labelSize.getX(), height);
                    doubleVector = breakBoxBounds;
                    if (doubleVector == null) break block3;
                    DoubleVector it = doubleVector;
                    boolean bl = false;
                    DoubleVector doubleVector2 = this.breakBoxOrigin(i, (DoubleRectangle)it);
                    doubleVector = doubleVector2;
                    if (doubleVector2 != null) break block4;
                }
                doubleVector = contentOrigin;
            }
            DoubleVector doubleVector3 = breakBoxSize;
            DoubleVector doubleVector4 = doubleVector;
            breakBoxBounds = new DoubleRectangle(doubleVector4, doubleVector3);
            this.myKeyLabelBoxes.add((DoubleRectangle)breakBoxBounds);
            this.myLabelBoxes.add(new DoubleRectangle(labelHOffset, labelVOffset, labelSize.getX(), labelSize.getY()));
        }
        this.myContentSize = GeometryUtil.INSTANCE.union(new DoubleRectangle(contentOrigin, DoubleVector.Companion.getZERO()), (Collection<DoubleRectangle>)this.myKeyLabelBoxes).getDimension();
    }

    @NotNull
    protected abstract DoubleVector breakBoxOrigin(int var1, @NotNull DoubleRectangle var2);

    @NotNull
    protected abstract DoubleVector labelSize(int var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$Companion;", "", "()V", "horizontal", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "horizontalMultiRow", "vertical", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LegendComponentLayout horizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new MyHorizontal(title, breaks, keySizes, theme);
        }

        @NotNull
        public final LegendComponentLayout horizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new MyHorizontalMultiRow(title, breaks, keySizes, theme);
        }

        @NotNull
        public final LegendComponentLayout vertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new MyVertical(title, breaks, keySizes, theme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyHorizontal;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "breakBoxOrigin", "index", "", "prevBreakBoxBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelSize", "plot-builder"})
    private static final class MyHorizontal
    extends LegendComponentLayout {
        public MyHorizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.HORIZONTAL, theme);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }

        @Override
        @NotNull
        protected DoubleVector breakBoxOrigin(int index, @NotNull DoubleRectangle prevBreakBoxBounds) {
            Intrinsics.checkNotNullParameter((Object)prevBreakBoxBounds, (String)"prevBreakBoxBounds");
            return new DoubleVector(prevBreakBoxBounds.getRight(), 0.0);
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            String label = this.getBreaks().get(index).getLabel();
            return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(label, PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyHorizontalMultiRow;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "plot-builder"})
    private static final class MyHorizontalMultiRow
    extends MyMultiRow {
        public MyHorizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.HORIZONTAL, theme);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "myMaxLabelWidth", "", "breakBoxOrigin", "index", "", "prevBreakBoxBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelSize", "plot-builder"})
    private static abstract class MyMultiRow
    extends LegendComponentLayout {
        private double myMaxLabelWidth;

        public MyMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendDirection legendDirection, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)legendDirection, (String)"legendDirection");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, breaks, keySizes, legendDirection, theme);
            for (LegendBreak br : breaks) {
                this.myMaxLabelWidth = Math.max(this.myMaxLabelWidth, PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(br.getLabel(), PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getX());
            }
        }

        @Override
        @NotNull
        protected DoubleVector breakBoxOrigin(int index, @NotNull DoubleRectangle prevBreakBoxBounds) {
            Intrinsics.checkNotNullParameter((Object)prevBreakBoxBounds, (String)"prevBreakBoxBounds");
            if (this.isFillByRow()) {
                return index % this.getColCount() == 0 ? new DoubleVector(0.0, prevBreakBoxBounds.getBottom()) : new DoubleVector(prevBreakBoxBounds.getRight(), prevBreakBoxBounds.getTop());
            }
            return index % this.getRowCount() == 0 ? new DoubleVector(prevBreakBoxBounds.getRight(), 0.0) : new DoubleVector(prevBreakBoxBounds.getLeft(), prevBreakBoxBounds.getBottom());
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            return new DoubleVector(this.myMaxLabelWidth, PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(this.getBreaks().get(index).getLabel(), PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme())).getY());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyVertical;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBreak;", "keySizes", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "plot-builder"})
    private static final class MyVertical
    extends MyMultiRow {
        public MyVertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull List<DoubleVector> keySizes, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter(keySizes, (String)"keySizes");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, breaks, keySizes, LegendDirection.VERTICAL, theme);
            this.setColCount(1);
            this.setRowCount(breaks.size());
        }
    }
}

