/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.render.svg.TextLabel;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003&'(Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010%\u001a\u00020#H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "length", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "gridLineLength", "gridLineDistance", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "hideAxis", "", "hideAxisBreaks", "hideGridlines", "(DLorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;DDLorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;ZZZ)V", "buildAxis", "", "buildComponent", "buildGridLine", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLineElement;", "br", "width", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "buildTick", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "label", "", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "skipLabel", "tickLabelBaseOffset", "BreaksData", "TickLabelAdjustments", "TickLabelsCleaner", "plot-builder"})
public final class AxisComponent
extends SvgComponent {
    private final double length;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final BreaksData breaksData;
    @NotNull
    private final TickLabelAdjustments labelAdjustments;
    private final double gridLineLength;
    private final double gridLineDistance;
    @NotNull
    private final AxisTheme axisTheme;
    @NotNull
    private final PanelGridTheme gridTheme;
    private final boolean hideAxis;
    private final boolean hideAxisBreaks;
    private final boolean hideGridlines;

    public AxisComponent(double length, @NotNull Orientation orientation, @NotNull BreaksData breaksData, @NotNull TickLabelAdjustments labelAdjustments, double gridLineLength, double gridLineDistance, @NotNull AxisTheme axisTheme, @NotNull PanelGridTheme gridTheme, boolean hideAxis, boolean hideAxisBreaks, boolean hideGridlines) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaksData, (String)"breaksData");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
        this.length = length;
        this.orientation = orientation;
        this.breaksData = breaksData;
        this.labelAdjustments = labelAdjustments;
        this.gridLineLength = gridLineLength;
        this.gridLineDistance = gridLineDistance;
        this.axisTheme = axisTheme;
        this.gridTheme = gridTheme;
        this.hideAxis = hideAxis;
        this.hideAxisBreaks = hideAxisBreaks;
        this.hideGridlines = hideGridlines;
    }

    public /* synthetic */ AxisComponent(double d, Orientation orientation, BreaksData breaksData, TickLabelAdjustments tickLabelAdjustments, double d2, double d3, AxisTheme axisTheme, PanelGridTheme panelGridTheme, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tickLabelAdjustments = new TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        if ((n & 0x200) != 0) {
            bl2 = false;
        }
        if ((n & 0x400) != 0) {
            bl3 = false;
        }
        this(d, orientation, breaksData, tickLabelAdjustments, d2, d3, axisTheme, panelGridTheme, bl, bl2, bl3);
    }

    protected void buildComponent() {
        this.buildAxis();
    }

    private final void buildAxis() {
        SvgGElement rootElement = this.getRootGroup();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double start = 0.0;
        double end = this.length;
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: 
            case 2: {
                x1 = 0.0;
                x2 = 0.0;
                y1 = start;
                y2 = end;
                break;
            }
            case 3: 
            case 4: {
                x1 = start;
                x2 = end;
                y1 = 0.0;
                y2 = 0.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!this.hideGridlines) {
            SvgLineElement elem;
            double br;
            Iterator<Double> iterator;
            double gridLineMinPos = start + (double)6;
            double gridLineMaxPos = end - (double)6;
            if (this.gridTheme.showMinor()) {
                iterator = this.breaksData.getMinorBreaks().iterator();
                while (iterator.hasNext()) {
                    br = ((Number)iterator.next()).doubleValue();
                    if (!(br >= gridLineMinPos) || !(br <= gridLineMaxPos)) continue;
                    elem = this.buildGridLine(br, this.gridTheme.minorLineWidth(), this.gridTheme.minorLineColor());
                    rootElement.children().add((Object)elem);
                }
            }
            if (this.gridTheme.showMajor()) {
                iterator = this.breaksData.getMajorBreaks().iterator();
                while (iterator.hasNext()) {
                    br = ((Number)iterator.next()).doubleValue();
                    if (!(br >= gridLineMinPos) || !(br <= gridLineMaxPos)) continue;
                    elem = this.buildGridLine(br, this.gridTheme.majorLineWidth(), this.gridTheme.majorLineColor());
                    rootElement.children().add((Object)elem);
                }
            }
        }
        if (!this.hideAxis) {
            Object object;
            if (!this.hideAxisBreaks && (this.axisTheme.showLabels() || this.axisTheme.showTickMarks())) {
                TickLabelsCleaner labelsCleaner = new TickLabelsCleaner(this.orientation.isHorizontal(), PlotLabelSpecFactory.INSTANCE.axisTick(this.axisTheme));
                object = this.breaksData.getMajorBreaks().iterator();
                int gridLineMaxPos = 0;
                while (object.hasNext()) {
                    int i = gridLineMaxPos++;
                    double br = ((Number)object.next()).doubleValue();
                    if (!(br >= start) || !(br <= end)) continue;
                    String label = this.breaksData.getMajorLabels().get(i % this.breaksData.getMajorLabels().size());
                    DoubleVector labelOffset = this.tickLabelBaseOffset().add(this.labelAdjustments.additionalOffset(i));
                    SvgGElement group = this.buildTick(label, labelOffset, !labelsCleaner.beforeAddLabel(br, label, this.labelAdjustments.getRotationDegree(), labelOffset), this.axisTheme);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
                        case 1: 
                        case 2: {
                            SvgUtils.INSTANCE.transformTranslate((SvgTransformable)group, 0.0, br);
                            break;
                        }
                        case 3: 
                        case 4: {
                            SvgUtils.INSTANCE.transformTranslate((SvgTransformable)group, br, 0.0);
                        }
                    }
                    rootElement.children().add((Object)group);
                }
            }
            if (!this.hideAxisBreaks && this.axisTheme.showLine()) {
                object = new SvgLineElement(x1, y1, x2, y2);
                SvgLineElement $this$buildAxis_u24lambda_u240 = object;
                boolean bl = false;
                $this$buildAxis_u24lambda_u240.strokeWidth().set((Object)this.axisTheme.lineWidth());
                $this$buildAxis_u24lambda_u240.strokeColor().set((Object)this.axisTheme.lineColor());
                Object axisLine = object;
                rootElement.children().add(axisLine);
            }
        }
    }

    private final SvgLineElement buildGridLine(double br, double width, Color color) {
        SvgLineElement svgLineElement;
        double start = this.gridLineDistance;
        double end = start + this.gridLineLength;
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                svgLineElement = new SvgLineElement(start, 0.0, end, 0.0);
                break;
            }
            case 2: {
                svgLineElement = new SvgLineElement(-start, 0.0, -end, 0.0);
                break;
            }
            case 3: {
                svgLineElement = new SvgLineElement(0.0, start, 0.0, end);
                break;
            }
            case 4: {
                svgLineElement = new SvgLineElement(0.0, -start, 0.0, -end);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SvgLineElement elem = svgLineElement;
        elem.strokeColor().set((Object)color);
        elem.strokeWidth().set((Object)width);
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: 
            case 2: {
                elem.y1().set((Object)br);
                elem.y2().set((Object)br);
                break;
            }
            case 3: 
            case 4: {
                elem.x1().set((Object)br);
                elem.x2().set((Object)br);
            }
        }
        return elem;
    }

    private final SvgGElement buildTick(String label, DoubleVector labelOffset, boolean skipLabel, AxisTheme axisTheme) {
        SvgLineElement tickMark = null;
        if (axisTheme.showTickMarks()) {
            tickMark = new SvgLineElement();
            tickMark.strokeWidth().set((Object)axisTheme.tickMarkWidth());
            tickMark.strokeColor().set((Object)axisTheme.tickMarkColor());
        }
        TextLabel tickLabel = null;
        if (!skipLabel && axisTheme.showLabels()) {
            tickLabel = new TextLabel(label);
            tickLabel.addClassName("axis-text-" + axisTheme.getAxis());
        }
        double markLength = axisTheme.tickMarkLength();
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                if (tickMark == null) break;
                tickMark.x2().set((Object)(-markLength));
                tickMark.y2().set((Object)0.0);
                break;
            }
            case 2: {
                if (tickMark == null) break;
                tickMark.x2().set((Object)markLength);
                tickMark.y2().set((Object)0.0);
                break;
            }
            case 3: {
                if (tickMark == null) break;
                tickMark.x2().set((Object)0.0);
                tickMark.y2().set((Object)(-markLength));
                break;
            }
            case 4: {
                if (tickMark == null) break;
                tickMark.x2().set((Object)0.0);
                tickMark.y2().set((Object)markLength);
            }
        }
        SvgGElement g = new SvgGElement();
        if (tickMark != null) {
            g.children().add((Object)tickMark);
        }
        if (tickLabel != null) {
            tickLabel.moveTo(labelOffset.getX(), labelOffset.getY());
            tickLabel.setHorizontalAnchor(this.labelAdjustments.getHorizontalAnchor());
            tickLabel.setVerticalAnchor(this.labelAdjustments.getVerticalAnchor());
            tickLabel.rotate(this.labelAdjustments.getRotationDegree());
            g.children().add((Object)tickLabel.getRootGroup());
        }
        return g;
    }

    private final DoubleVector tickLabelBaseOffset() {
        DoubleVector doubleVector;
        double distance = this.axisTheme.tickLabelDistance(this.orientation.isHorizontal());
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(this.axisTheme.tickLabelMargins().getLeft() - distance, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(distance - this.axisTheme.tickLabelMargins().getRight(), 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, this.axisTheme.tickLabelMargins().getTop() - distance);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, distance - this.axisTheme.tickLabelMargins().getBottom());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData;", "", "majorBreaks", "", "", "majorLabels", "", "minorBreaks", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getMajorBreaks", "()Ljava/util/List;", "getMajorLabels", "getMinorBreaks", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,348:1\n1789#2,3:349\n2661#2,7:352\n2661#2,7:359\n*S KotlinDebug\n*F\n+ 1 AxisComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$BreaksData\n*L\n257#1:349,3\n263#1:352,7\n268#1:359,7\n*E\n"})
    public static final class BreaksData {
        @NotNull
        private final List<Double> majorBreaks;
        @NotNull
        private final List<String> majorLabels;
        @NotNull
        private final List<Double> minorBreaks;

        /*
         * WARNING - void declaration
         */
        public BreaksData(@NotNull List<Double> majorBreaks, @NotNull List<String> majorLabels, @Nullable List<Double> minorBreaks) {
            Intrinsics.checkNotNullParameter(majorBreaks, (String)"majorBreaks");
            Intrinsics.checkNotNullParameter(majorLabels, (String)"majorLabels");
            this.majorBreaks = majorBreaks;
            this.majorLabels = majorLabels;
            BreaksData breaksData = this;
            List list = minorBreaks;
            if (list == null) {
                List list2;
                BreaksData breaksData2 = this;
                BreaksData breaksData3 = breaksData;
                boolean bl = false;
                if (this.majorBreaks.size() <= 1) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    double second;
                    double first;
                    void $this$fold$iv;
                    Iterable iterable = CollectionsKt.zip((Iterable)this.majorBreaks.subList(0, this.majorBreaks.size() - 1), (Iterable)this.majorBreaks.subList(1, this.majorBreaks.size()));
                    ArrayList<Double> initial$iv = new ArrayList<Double>();
                    boolean $i$f$fold = false;
                    Serializable accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void pair;
                        Pair pair2 = (Pair)element$iv;
                        ArrayList<Double> l = accumulator$iv;
                        boolean bl2 = false;
                        l.add((((Number)pair.getSecond()).doubleValue() - ((Number)pair.getFirst()).doubleValue()) / (double)2 + ((Number)pair.getFirst()).doubleValue());
                        accumulator$iv = l;
                    }
                    List minorBreaks2 = accumulator$iv;
                    Iterable $this$reduce$iv = CollectionsKt.take((Iterable)this.majorBreaks, (int)2);
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        double d = ((Number)iterator$iv.next()).doubleValue();
                        first = ((Number)accumulator$iv).doubleValue();
                        boolean bl3 = false;
                        accumulator$iv = (double)(second - first);
                    }
                    double $this$minorBreaks_u24lambda_u245_u24lambda_u242 = ((Number)accumulator$iv).doubleValue();
                    boolean bl4 = false;
                    minorBreaks2.add(0, ((Number)CollectionsKt.first((List)minorBreaks2)).doubleValue() - $this$minorBreaks_u24lambda_u245_u24lambda_u242);
                    $this$reduce$iv = CollectionsKt.takeLast(this.majorBreaks, (int)2);
                    $i$f$reduce = false;
                    iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv2 = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        second = ((Number)iterator$iv.next()).doubleValue();
                        first = ((Number)accumulator$iv2).doubleValue();
                        boolean bl5 = false;
                        accumulator$iv2 = second - first;
                    }
                    double $this$minorBreaks_u24lambda_u245_u24lambda_u244 = ((Number)accumulator$iv2).doubleValue();
                    boolean bl6 = false;
                    minorBreaks2.add(0, ((Number)CollectionsKt.last((List)minorBreaks2)).doubleValue() + $this$minorBreaks_u24lambda_u245_u24lambda_u244);
                    list2 = minorBreaks2;
                }
                list = list2;
                breaksData = breaksData3;
            }
            breaksData.minorBreaks = list;
        }

        public /* synthetic */ BreaksData(List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list3 = null;
            }
            this(list, list2, list3);
        }

        @NotNull
        public final List<Double> getMajorBreaks() {
            return this.majorBreaks;
        }

        @NotNull
        public final List<String> getMajorLabels() {
            return this.majorLabels;
        }

        @NotNull
        public final List<Double> getMinorBreaks() {
            return this.minorBreaks;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "horizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "verticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "rotationDegree", "", "additionalOffsets", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;DLjava/util/List;)V", "getHorizontalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "getRotationDegree", "()D", "getVerticalAnchor", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "additionalOffset", "tickIndex", "", "plot-builder"})
    public static final class TickLabelAdjustments {
        private final double rotationDegree;
        @Nullable
        private final List<DoubleVector> additionalOffsets;
        @NotNull
        private final Text.HorizontalAnchor horizontalAnchor;
        @NotNull
        private final Text.VerticalAnchor verticalAnchor;

        public TickLabelAdjustments(@NotNull Orientation orientation, @Nullable Text.HorizontalAnchor horizontalAnchor, @Nullable Text.VerticalAnchor verticalAnchor, double rotationDegree, @Nullable List<DoubleVector> additionalOffsets) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.rotationDegree = rotationDegree;
            this.additionalOffsets = additionalOffsets;
            Text.HorizontalAnchor horizontalAnchor2 = horizontalAnchor;
            if (horizontalAnchor2 == null) {
                switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                    case 1: {
                        horizontalAnchor2 = Text.HorizontalAnchor.RIGHT;
                        break;
                    }
                    case 2: {
                        horizontalAnchor2 = Text.HorizontalAnchor.LEFT;
                        break;
                    }
                    case 3: 
                    case 4: {
                        horizontalAnchor2 = Text.HorizontalAnchor.MIDDLE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.horizontalAnchor = horizontalAnchor2;
            Text.VerticalAnchor verticalAnchor2 = verticalAnchor;
            if (verticalAnchor2 == null) {
                switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                    case 1: 
                    case 2: {
                        verticalAnchor2 = Text.VerticalAnchor.CENTER;
                        break;
                    }
                    case 3: {
                        verticalAnchor2 = Text.VerticalAnchor.BOTTOM;
                        break;
                    }
                    case 4: {
                        verticalAnchor2 = Text.VerticalAnchor.TOP;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.verticalAnchor = verticalAnchor2;
        }

        public /* synthetic */ TickLabelAdjustments(Orientation orientation, Text.HorizontalAnchor horizontalAnchor, Text.VerticalAnchor verticalAnchor, double d, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                horizontalAnchor = null;
            }
            if ((n & 4) != 0) {
                verticalAnchor = null;
            }
            if ((n & 8) != 0) {
                d = 0.0;
            }
            if ((n & 0x10) != 0) {
                list = null;
            }
            this(orientation, horizontalAnchor, verticalAnchor, d, list);
        }

        public final double getRotationDegree() {
            return this.rotationDegree;
        }

        @NotNull
        public final Text.HorizontalAnchor getHorizontalAnchor() {
            return this.horizontalAnchor;
        }

        @NotNull
        public final Text.VerticalAnchor getVerticalAnchor() {
            return this.verticalAnchor;
        }

        @NotNull
        public final DoubleVector additionalOffset(int tickIndex) {
            DoubleVector doubleVector = this.additionalOffsets;
            if (doubleVector == null || (doubleVector = doubleVector.get(tickIndex)) == null) {
                doubleVector = DoubleVector.Companion.getZERO();
            }
            return doubleVector;
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                try {
                    nArray[Orientation.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.TOP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.BOTTOM.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelsCleaner;", "", "horizontalAxis", "", "labelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "(ZLorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;)V", "filledAreas", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lkotlin/collections/ArrayList;", "beforeAddLabel", "loc", "", "label", "", "rotationDegree", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isHorizontal", "isRelevant", "isVertical", "labelRect", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelsCleaner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,348:1\n1747#2,3:349\n*S KotlinDebug\n*F\n+ 1 AxisComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelsCleaner\n*L\n308#1:349,3\n*E\n"})
    private static final class TickLabelsCleaner {
        private final boolean horizontalAxis;
        @NotNull
        private final LabelSpec labelSpec;
        @NotNull
        private final ArrayList<DoubleRectangle> filledAreas;

        public TickLabelsCleaner(boolean horizontalAxis, @NotNull LabelSpec labelSpec) {
            Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
            this.horizontalAxis = horizontalAxis;
            this.labelSpec = labelSpec;
            this.filledAreas = new ArrayList();
        }

        public final boolean beforeAddLabel(double loc, @NotNull String label, double rotationDegree, @NotNull DoubleVector labelOffset) {
            boolean bl;
            DoubleRectangle rect2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)labelOffset, (String)"labelOffset");
                if (!this.isRelevant(rotationDegree)) {
                    return true;
                }
                rect2 = this.labelRect(loc, label, rotationDegree, labelOffset);
                Iterable $this$any$iv = this.filledAreas;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl2 = false;
                        if (!it.intersects(rect2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            this.filledAreas.add(rect2);
            return true;
        }

        private final boolean isRelevant(double rotationDegree) {
            return this.isVertical(rotationDegree) || this.isHorizontal(rotationDegree);
        }

        private final boolean isHorizontal(double rotationDegree) {
            return rotationDegree % (double)180 == 0.0;
        }

        private final boolean isVertical(double rotationDegree) {
            return Math.abs(rotationDegree / (double)90) % (double)2 == 1.0;
        }

        private final DoubleRectangle labelRect(double loc, String label, double rotationDegree, DoubleVector labelOffset) {
            DoubleVector labelNormalSize = this.labelSpec.dimensions(label);
            DoubleVector wh = this.isVertical(rotationDegree) ? labelNormalSize.flip() : labelNormalSize;
            DoubleVector origin = this.horizontalAxis ? new DoubleVector(loc, 0.0) : new DoubleVector(0.0, loc);
            return new DoubleRectangle(origin, wh).subtract(wh.mul(0.5)).add(labelOffset);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

