/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.MarginalLayerCoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.MarginalFrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProviderFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.InsideOutTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.TopDownTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002-.BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\u0010\u0014J4\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0016J \u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReferenceProvider;", "hScaleProto", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "vScaleProto", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "hAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisPosition", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "domainByMargin", "", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "(Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ZLorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Ljava/util/Map;)V", "getFlipAxis", "()Z", "hAxisLabel", "", "getHAxisLabel", "()Ljava/lang/String;", "hAxisSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider$AxisSpec;", "vAxisLabel", "getVAxisLabel", "vAxisSpec", "createMarginalFrames", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "tileLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "plotBackground", "Lorg/jetbrains/letsPlot/commons/values/Color;", "debugDrawing", "createTileFrame", "layoutInfo", "createTileLayoutProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "AxisSpec", "MyTileLayoutProvider", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSquareFrameOfReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReferenceProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n442#2:246\n392#2:247\n442#2:252\n392#2:253\n1238#3,4:248\n1238#3,4:254\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReferenceProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider\n*L\n173#1:246\n173#1:247\n188#1:252\n188#1:253\n173#1:248,4\n188#1:254,4\n*E\n"})
public final class SquareFrameOfReferenceProvider
implements FrameOfReferenceProvider {
    @NotNull
    private final Scale hScaleProto;
    @NotNull
    private final Scale vScaleProto;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    private final boolean flipAxis;
    @NotNull
    private final AxisPosition hAxisPosition;
    @NotNull
    private final AxisPosition vAxisPosition;
    @NotNull
    private final Theme theme;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Map<MarginSide, DoubleSpan> domainByMargin;
    @NotNull
    private final AxisSpec hAxisSpec;
    @NotNull
    private final AxisSpec vAxisSpec;
    @Nullable
    private final String hAxisLabel;
    @Nullable
    private final String vAxisLabel;

    public SquareFrameOfReferenceProvider(@NotNull Scale hScaleProto, @NotNull Scale vScaleProto, @NotNull DoubleRectangle adjustedDomain, boolean flipAxis, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull Theme theme, @NotNull GeomMarginsLayout marginsLayout, @NotNull Map<MarginSide, DoubleSpan> domainByMargin) {
        Intrinsics.checkNotNullParameter((Object)hScaleProto, (String)"hScaleProto");
        Intrinsics.checkNotNullParameter((Object)vScaleProto, (String)"vScaleProto");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter(domainByMargin, (String)"domainByMargin");
        this.hScaleProto = hScaleProto;
        this.vScaleProto = vScaleProto;
        this.adjustedDomain = adjustedDomain;
        this.flipAxis = flipAxis;
        this.hAxisPosition = hAxisPosition;
        this.vAxisPosition = vAxisPosition;
        this.theme = theme;
        this.marginsLayout = marginsLayout;
        this.domainByMargin = domainByMargin;
        this.hAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.hScaleProto), this.hScaleProto.getName(), this.theme.horizontalAxis(this.getFlipAxis()));
        this.vAxisSpec = new AxisSpec(AxisBreaksProviderFactory.Companion.forScale(this.vScaleProto), this.vScaleProto.getName(), this.theme.verticalAxis(this.getFlipAxis()));
        this.hAxisLabel = this.hAxisSpec.getTheme().showTitle() ? this.hAxisSpec.getLabel() : null;
        this.vAxisLabel = this.vAxisSpec.getTheme().showTitle() ? this.vAxisSpec.getLabel() : null;
    }

    @Override
    public boolean getFlipAxis() {
        return this.flipAxis;
    }

    @Override
    @Nullable
    public String getHAxisLabel() {
        return this.hAxisLabel;
    }

    @Override
    @Nullable
    public String getVAxisLabel() {
        return this.vAxisLabel;
    }

    @Override
    @NotNull
    public TileLayoutProvider createTileLayoutProvider() {
        AxisLayoutQuad axisLayoutQuad = new AxisLayoutQuad(SquareFrameOfReferenceProvider.createTileLayoutProvider$toAxisLayout(Orientation.LEFT, this.vAxisPosition, this.vAxisSpec), SquareFrameOfReferenceProvider.createTileLayoutProvider$toAxisLayout(Orientation.RIGHT, this.vAxisPosition, this.vAxisSpec), SquareFrameOfReferenceProvider.createTileLayoutProvider$toAxisLayout(Orientation.TOP, this.hAxisPosition, this.hAxisSpec), SquareFrameOfReferenceProvider.createTileLayoutProvider$toAxisLayout(Orientation.BOTTOM, this.hAxisPosition, this.hAxisSpec));
        return new MyTileLayoutProvider(axisLayoutQuad, this.adjustedDomain, this.marginsLayout);
    }

    @Override
    @NotNull
    public FrameOfReference createTileFrame(@NotNull TileLayoutInfo layoutInfo, @NotNull CoordProvider coordProvider, boolean debugDrawing) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        AxisLayoutInfo axisLayoutInfo = layoutInfo.getAxisInfos().getBottom();
        if (axisLayoutInfo == null && (axisLayoutInfo = layoutInfo.getAxisInfos().getTop()) == null) {
            throw new IllegalStateException("No top/bottom axis info.");
        }
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = layoutInfo.getAxisInfos().getLeft();
        if (axisLayoutInfo2 == null && (axisLayoutInfo2 = layoutInfo.getAxisInfos().getRight()) == null) {
            throw new IllegalStateException("No left/right axis info.");
        }
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        DoubleVector client = new DoubleVector(hAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisLength());
        CoordinateSystem coord = coordProvider.createCoordinateSystem(this.adjustedDomain, client);
        Scale hScale = this.hScaleProto.with().breaks(hAxisLayoutInfo.getAxisBreaks().getDomainValues()).labels(hAxisLayoutInfo.getAxisBreaks().getLabels()).build();
        Scale vScale = this.vScaleProto.with().breaks(vAxisLayoutInfo.getAxisBreaks().getDomainValues()).labels(vAxisLayoutInfo.getAxisBreaks().getLabels()).build();
        SquareFrameOfReference tileFrameOfReference = new SquareFrameOfReference(hScale.getScaleBreaks(), vScale.getScaleBreaks(), this.adjustedDomain, coord, layoutInfo, this.marginsLayout, this.theme, this.getFlipAxis());
        tileFrameOfReference.setDebugDrawing(debugDrawing);
        return tileFrameOfReference;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<MarginSide, FrameOfReference> createMarginalFrames(@NotNull TileLayoutInfo tileLayoutInfo, @NotNull CoordProvider coordProvider, @NotNull Color plotBackground, boolean debugDrawing) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object object2;
        Object k;
        Object object3;
        void $this$mapValuesTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tileLayoutInfo, (String)"tileLayoutInfo");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)plotBackground, (String)"plotBackground");
        if (this.domainByMargin.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (!(!coordProvider.getFlipped())) {
            boolean $i$a$-check-SquareFrameOfReferenceProvider$createMarginalFrames$22 = false;
            String $i$a$-check-SquareFrameOfReferenceProvider$createMarginalFrames$22 = "`flipped` corrdinate system is not supported on plots with marginal layers.";
            throw new IllegalStateException($i$a$-check-SquareFrameOfReferenceProvider$createMarginalFrames$22.toString());
        }
        DoubleRectangle inner = tileLayoutInfo.getGeomInnerBounds();
        DoubleRectangle outer = tileLayoutInfo.getGeomOuterBounds();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)MarginSide.LEFT), (Object)new DoubleVector(outer.getLeft(), inner.getTop())), TuplesKt.to((Object)((Object)MarginSide.TOP), (Object)new DoubleVector(inner.getLeft(), outer.getTop())), TuplesKt.to((Object)((Object)MarginSide.RIGHT), (Object)new DoubleVector(inner.getRight(), inner.getTop())), TuplesKt.to((Object)((Object)MarginSide.BOTTOM), (Object)new DoubleVector(inner.getLeft(), inner.getBottom()))};
        Map origins = MapsKt.mapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)MarginSide.LEFT), (Object)new DoubleVector(Math.max(0.0, inner.getLeft() - outer.getLeft()), inner.getHeight())), TuplesKt.to((Object)((Object)MarginSide.TOP), (Object)new DoubleVector(inner.getWidth(), Math.max(0.0, inner.getTop() - outer.getTop()))), TuplesKt.to((Object)((Object)MarginSide.RIGHT), (Object)new DoubleVector(Math.max(0.0, outer.getRight() - inner.getRight()), inner.getHeight())), TuplesKt.to((Object)((Object)MarginSide.BOTTOM), (Object)new DoubleVector(inner.getWidth(), Math.max(0.0, outer.getBottom() - inner.getBottom())))};
        Map sizes = MapsKt.mapOf((Pair[])pairArray2);
        Map $this$mapValues$iv = origins;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            object3 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = map3;
            boolean bl2 = false;
            MarginSide margin = (MarginSide)((Object)object3.getKey());
            DoubleVector origin = (DoubleVector)object3.getValue();
            object = new DoubleRectangle(origin, (DoubleVector)MapsKt.getValue((Map)sizes, (Object)((Object)margin)));
            object2.put(k, object);
        }
        Map boundsByMargin = destination$iv$iv;
        AxisLayoutInfo axisLayoutInfo = tileLayoutInfo.getAxisInfos().getBottom();
        if (axisLayoutInfo == null && (axisLayoutInfo = tileLayoutInfo.getAxisInfos().getTop()) == null) {
            throw new IllegalStateException("No top/bottom axis info.");
        }
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = tileLayoutInfo.getAxisInfos().getLeft();
        if (axisLayoutInfo2 == null && (axisLayoutInfo2 = tileLayoutInfo.getAxisInfos().getRight()) == null) {
            throw new IllegalStateException("No left/right axis info.");
        }
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        Map<MarginSide, DoubleSpan> $this$mapValues$iv2 = this.domainByMargin;
        boolean $i$f$mapValues2 = false;
        Map<MarginSide, DoubleSpan> $i$f$mapValuesTo22 = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            DoubleSpan doubleSpan;
            DoubleSpan doubleSpan2;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv2;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object3;
            boolean bl3 = false;
            MarginSide side = (MarginSide)((Object)entry.getKey());
            DoubleSpan domain = (DoubleSpan)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$1[side.ordinal()]) {
                case 1: 
                case 2: {
                    doubleSpan2 = domain;
                    break;
                }
                case 3: 
                case 4: {
                    doubleSpan2 = hAxisLayoutInfo.getAxisDomain();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleSpan hDomain = doubleSpan2;
            switch (WhenMappings.$EnumSwitchMapping$1[side.ordinal()]) {
                case 1: 
                case 2: {
                    doubleSpan = vAxisLayoutInfo.getAxisDomain();
                    break;
                }
                case 3: 
                case 4: {
                    doubleSpan = domain;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleSpan vDomain = doubleSpan;
            MarginalLayerCoordProvider marginCoordProvider = new MarginalLayerCoordProvider();
            DoubleVector clientSize = (DoubleVector)MapsKt.getValue((Map)sizes, (Object)((Object)side));
            DoubleRectangle adjustedDomain = new DoubleRectangle(hDomain, vDomain);
            CoordinateSystem coord = marginCoordProvider.createCoordinateSystem(adjustedDomain, clientSize);
            object = new MarginalFrameOfReference((DoubleRectangle)MapsKt.getValue((Map)boundsByMargin, (Object)((Object)side)), adjustedDomain, coord, plotBackground, debugDrawing);
            object2.put(k, object);
        }
        return destination$iv$iv2;
    }

    private static final AxisLayout createTileLayoutProvider$toAxisLayout(Orientation orientation, AxisPosition position, AxisSpec spec) {
        AxisLayout axisLayout;
        Orientation orientation2;
        Orientation orientation3;
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                if (position.isLeft()) {
                    orientation3 = orientation;
                    break;
                }
                orientation3 = null;
                break;
            }
            case 2: {
                if (position.isRight()) {
                    orientation3 = orientation;
                    break;
                }
                orientation3 = null;
                break;
            }
            case 3: {
                if (position.isTop()) {
                    orientation3 = orientation;
                    break;
                }
                orientation3 = null;
                break;
            }
            case 4: {
                if (position.isBottom()) {
                    orientation3 = orientation;
                    break;
                }
                orientation3 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Orientation orientation4 = orientation2 = orientation3;
        if (orientation4 != null) {
            Orientation $this$createTileLayoutProvider_u24toAxisLayout_u24lambda_u240 = orientation4;
            boolean bl = false;
            axisLayout = new AxisLayout(spec.getBreaksProviderFactory(), orientation2, spec.getTheme());
        } else {
            axisLayout = null;
        }
        return axisLayout;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider$AxisSpec;", "", "breaksProviderFactory", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProviderFactory;", "label", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProviderFactory;Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "getBreaksProviderFactory", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProviderFactory;", "getLabel", "()Ljava/lang/String;", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "plot-builder"})
    private static final class AxisSpec {
        @NotNull
        private final AxisBreaksProviderFactory breaksProviderFactory;
        @Nullable
        private final String label;
        @NotNull
        private final AxisTheme theme;

        public AxisSpec(@NotNull AxisBreaksProviderFactory breaksProviderFactory, @Nullable String label, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter((Object)breaksProviderFactory, (String)"breaksProviderFactory");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            this.breaksProviderFactory = breaksProviderFactory;
            this.label = label;
            this.theme = theme;
        }

        @NotNull
        public final AxisBreaksProviderFactory getBreaksProviderFactory() {
            return this.breaksProviderFactory;
        }

        @Nullable
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final AxisTheme getTheme() {
            return this.theme;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider$MyTileLayoutProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;)V", "createInsideOutTileLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "createTopDownTileLayout", "plot-builder"})
    private static final class MyTileLayoutProvider
    implements TileLayoutProvider {
        @NotNull
        private final AxisLayoutQuad axisLayoutQuad;
        @NotNull
        private final DoubleRectangle adjustedDomain;
        @NotNull
        private final GeomMarginsLayout marginsLayout;

        public MyTileLayoutProvider(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleRectangle adjustedDomain, @NotNull GeomMarginsLayout marginsLayout) {
            Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
            Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
            Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
            this.axisLayoutQuad = axisLayoutQuad;
            this.adjustedDomain = adjustedDomain;
            this.marginsLayout = marginsLayout;
        }

        @Override
        @NotNull
        public TileLayout createTopDownTileLayout() {
            return new TopDownTileLayout(this.axisLayoutQuad, this.adjustedDomain.xRange(), this.adjustedDomain.yRange(), this.marginsLayout);
        }

        @Override
        @NotNull
        public TileLayout createInsideOutTileLayout() {
            return new InsideOutTileLayout(this.axisLayoutQuad, this.adjustedDomain.xRange(), this.adjustedDomain.yRange(), this.marginsLayout);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MarginSide.values().length];
            try {
                nArray[MarginSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarginSide.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

