/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.LayerRendererUtil;
import org.jetbrains.letsPlot.core.plot.builder.SvgLayerRenderer;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomContextBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ImmutableGeomContext;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0006H\u0002J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference;", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "isDebugDrawing", "()Z", "setDebugDrawing", "(Z)V", "buildGeomComponent", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "drawAfterGeomLayer", "", "parent", "drawBeforeGeomLayer", "drawDebugShapes", "geomBounds", "drawPanelAndAxis", "beforeGeomLayer", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1855#2,2:337\n1855#2,2:339\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference\n*L\n87#1:337,2\n112#1:339,2\n*E\n"})
public final class SquareFrameOfReference
implements FrameOfReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleBreaks hScaleBreaks;
    @NotNull
    private final ScaleBreaks vScaleBreaks;
    @NotNull
    private final DoubleRectangle adjustedDomain;
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final TileLayoutInfo layoutInfo;
    @NotNull
    private final GeomMarginsLayout marginsLayout;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    private boolean isDebugDrawing;

    public SquareFrameOfReference(@NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, @NotNull DoubleRectangle adjustedDomain, @NotNull CoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme, boolean flipAxis) {
        Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.hScaleBreaks = hScaleBreaks;
        this.vScaleBreaks = vScaleBreaks;
        this.adjustedDomain = adjustedDomain;
        this.coord = coord;
        this.layoutInfo = layoutInfo;
        this.marginsLayout = marginsLayout;
        this.theme = theme;
        this.flipAxis = flipAxis;
    }

    public final boolean isDebugDrawing() {
        return this.isDebugDrawing;
    }

    public final void setDebugDrawing(boolean bl) {
        this.isDebugDrawing = bl;
    }

    @Override
    public void drawBeforeGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, true);
    }

    @Override
    public void drawAfterGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, false);
    }

    private final void drawPanelAndAxis(SvgComponent parent, boolean beforeGeomLayer) {
        DoubleVector axisOrigin;
        AxisComponent axisComponent;
        AxisLayoutInfo axisInfo;
        Object element$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object[] panel;
        boolean drawVAxis;
        DoubleRectangle geomBounds = this.layoutInfo.getGeomInnerBounds();
        DoubleRectangle geomOuterBounds = this.layoutInfo.getGeomOuterBounds();
        PanelTheme panelTheme = this.theme.panel();
        AxisTheme hAxisTheme = this.theme.horizontalAxis(this.flipAxis);
        AxisTheme vAxisTheme = this.theme.verticalAxis(this.flipAxis);
        PanelGridTheme hGridTheme = panelTheme.gridX(this.flipAxis);
        PanelGridTheme vGridTheme = panelTheme.gridY(this.flipAxis);
        boolean drawPanel = panelTheme.showRect() && beforeGeomLayer;
        boolean drawPanelBorder = panelTheme.showBorder() && !beforeGeomLayer;
        boolean drawGridlines = beforeGeomLayer;
        boolean drawHAxis = beforeGeomLayer ? !hAxisTheme.isOntop() : hAxisTheme.isOntop();
        boolean bl = beforeGeomLayer ? !vAxisTheme.isOntop() : (drawVAxis = vAxisTheme.isOntop());
        if (drawPanel) {
            panel = SquareFrameOfReference.Companion.buildPanelComponent(geomBounds, panelTheme);
            parent.add((SvgNode)panel);
        }
        if (drawHAxis || drawGridlines) {
            panel = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getTop(), this.layoutInfo.getAxisInfos().getBottom()};
            $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])panel);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                axisInfo = (AxisLayoutInfo)element$iv;
                boolean bl2 = false;
                axisComponent = SquareFrameOfReference.Companion.buildAxis(this.hScaleBreaks, axisInfo, !drawHAxis, !this.layoutInfo.getHAxisShown(), !drawGridlines, this.coord, this.flipAxis, hAxisTheme, hGridTheme, geomBounds.getHeight(), SquareFrameOfReference.Companion.gridLineDistance(geomBounds, geomOuterBounds, axisInfo.getOrientation()), this.isDebugDrawing);
                axisOrigin = this.marginsLayout.toAxisOrigin(geomBounds, axisInfo.getOrientation());
                axisComponent.moveTo(axisOrigin);
                parent.add((SvgComponent)axisComponent);
            }
        }
        if (drawVAxis || drawGridlines) {
            $this$forEach$iv = new AxisLayoutInfo[]{this.layoutInfo.getAxisInfos().getLeft(), this.layoutInfo.getAxisInfos().getRight()};
            $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])$this$forEach$iv);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                axisInfo = (AxisLayoutInfo)element$iv;
                boolean bl3 = false;
                axisComponent = SquareFrameOfReference.Companion.buildAxis(this.vScaleBreaks, axisInfo, !drawVAxis, !this.layoutInfo.getVAxisShown(), !drawGridlines, this.coord, this.flipAxis, vAxisTheme, vGridTheme, geomBounds.getWidth(), SquareFrameOfReference.Companion.gridLineDistance(geomBounds, geomOuterBounds, axisInfo.getOrientation()), this.isDebugDrawing);
                axisOrigin = this.marginsLayout.toAxisOrigin(geomBounds, axisInfo.getOrientation());
                axisComponent.moveTo(axisOrigin);
                parent.add((SvgComponent)axisComponent);
            }
        }
        if (drawPanelBorder) {
            SvgRectElement panelBorder = SquareFrameOfReference.Companion.buildPanelBorderComponent(geomBounds, panelTheme);
            parent.add((SvgNode)panelBorder);
        }
        if (this.isDebugDrawing && !beforeGeomLayer) {
            this.drawDebugShapes(parent, geomBounds);
        }
    }

    private final void drawDebugShapes(SvgComponent parent, DoubleRectangle geomBounds) {
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u242 = this;
        boolean bl = false;
        DoubleRectangle tileBounds = $this$drawDebugShapes_u24lambda_u242.layoutInfo.getGeomWithAxisBounds();
        SvgRectElement rect2 = new SvgRectElement(tileBounds);
        rect2.fillColor().set((Object)Color.Companion.getBLACK());
        rect2.strokeWidth().set((Object)0.0);
        rect2.fillOpacity().set((Object)0.1);
        parent.add((SvgNode)rect2);
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u243 = this;
        boolean bl2 = false;
        SvgRectElement rect3 = new SvgRectElement(geomBounds);
        rect3.fillColor().set((Object)Color.Companion.getPINK());
        rect3.strokeWidth().set((Object)1.0);
        rect3.fillOpacity().set((Object)0.5);
        parent.add((SvgNode)rect3);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        SvgComponent layerComponent = Companion.buildGeom$plot_builder(layer, this.adjustedDomain, this.coord, this.flipAxis, targetCollector, this.theme.plot().backgroundFill());
        DoubleRectangle geomBounds = this.layoutInfo.getGeomInnerBounds();
        layerComponent.moveTo(geomBounds.getOrigin());
        layerComponent.clipBounds(new DoubleRectangle(DoubleVector.Companion.getZERO(), geomBounds.getDimension()));
        return layerComponent;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jh\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\nH\u0002J=\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion;", "", "()V", "buildAxis", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "info", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "hideAxis", "", "hideAxisBreaks", "hideGridlines", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "flipAxis", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "gridLineLength", "", "gridLineDistance", "isDebugDrawing", "buildGeom", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "xyAesBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flippedAxis", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "buildGeom$plot_builder", "buildPanelBorderComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "bounds", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelTheme;", "buildPanelComponent", "geomInnerBounds", "geomOuterBounds", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nSquareFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1#2:337\n1855#3,2:338\n*S KotlinDebug\n*F\n+ 1 SquareFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReference$Companion\n*L\n245#1:338,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final AxisComponent buildAxis(ScaleBreaks scaleBreaks, AxisLayoutInfo info, boolean hideAxis, boolean hideAxisBreaks, boolean hideGridlines, CoordinateSystem coord, boolean flipAxis, AxisTheme axisTheme, PanelGridTheme gridTheme, double gridLineLength, double gridLineDistance, boolean isDebugDrawing) {
            AxisComponent axis;
            block4: {
                if (!(!hideAxis || !hideGridlines)) {
                    boolean $i$a$-check-SquareFrameOfReference$Companion$buildAxis$22 = false;
                    String $i$a$-check-SquareFrameOfReference$Companion$buildAxis$22 = "Trying to build an empty axis component";
                    throw new IllegalStateException($i$a$-check-SquareFrameOfReference$Companion$buildAxis$22.toString());
                }
                Orientation orientation = info.getOrientation();
                AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, info.getTickLabelHorizontalAnchor(), info.getTickLabelVerticalAnchor(), info.getTickLabelRotationAngle(), info.getTickLabelAdditionalOffsets());
                AxisComponent.BreaksData breaksData = AxisUtil.INSTANCE.breaksData(scaleBreaks, coord, flipAxis, orientation.isHorizontal());
                axis = new AxisComponent(info.getAxisLength(), orientation, breaksData, labelAdjustments, gridLineLength, gridLineDistance, axisTheme, gridTheme, hideAxis, hideAxisBreaks, hideGridlines);
                if (!isDebugDrawing) break block4;
                org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, info.getTickLabelsBounds(), Color.Companion.getGREEN());
                DoubleRectangle doubleRectangle = info.getTickLabelsTextBounds$plot_builder();
                if (doubleRectangle != null) {
                    DoubleRectangle it = doubleRectangle;
                    boolean bl = false;
                    org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_BLUE());
                }
                List<DoubleRectangle> list = info.getTickLabelBoundsList$plot_builder();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DoubleRectangle it = (DoubleRectangle)element$iv;
                        boolean bl = false;
                        org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference$Companion.buildAxis$drawDebugRect(axis, it, Color.Companion.getLIGHT_MAGENTA());
                    }
                }
            }
            return axis;
        }

        private final SvgRectElement buildPanelComponent(DoubleRectangle bounds, PanelTheme theme) {
            SvgRectElement svgRectElement;
            SvgRectElement $this$buildPanelComponent_u24lambda_u243 = svgRectElement = new SvgRectElement(bounds);
            boolean bl = false;
            $this$buildPanelComponent_u24lambda_u243.strokeColor().set((Object)theme.rectColor());
            $this$buildPanelComponent_u24lambda_u243.strokeWidth().set((Object)theme.rectStrokeWidth());
            $this$buildPanelComponent_u24lambda_u243.fillColor().set((Object)theme.rectFill());
            return svgRectElement;
        }

        private final SvgRectElement buildPanelBorderComponent(DoubleRectangle bounds, PanelTheme theme) {
            SvgRectElement svgRectElement;
            SvgRectElement $this$buildPanelBorderComponent_u24lambda_u244 = svgRectElement = new SvgRectElement(bounds);
            boolean bl = false;
            $this$buildPanelBorderComponent_u24lambda_u244.strokeColor().set((Object)theme.borderColor());
            $this$buildPanelBorderComponent_u24lambda_u244.strokeWidth().set((Object)theme.borderWidth());
            $this$buildPanelBorderComponent_u24lambda_u244.fillOpacity().set((Object)0.0);
            return svgRectElement;
        }

        @NotNull
        public final SvgComponent buildGeom$plot_builder(@NotNull GeomLayer layer, @NotNull DoubleRectangle xyAesBounds, @NotNull CoordinateSystem coord, boolean flippedAxis, @NotNull GeomTargetCollector targetCollector, @NotNull Color backgroundColor) {
            CoordinateSystem coordinateSystem;
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Intrinsics.checkNotNullParameter((Object)xyAesBounds, (String)"xyAesBounds");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
            Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
            LayerRendererUtil.LayerRendererData rendererData = LayerRendererUtil.INSTANCE.createLayerRendererData(layer);
            boolean flippedAxis2 = layer.isYOrientation() ? !flippedAxis : flippedAxis;
            Map<Aes<?>, ScaleMapper<?>> aestheticMappers = rendererData.getAestheticMappers();
            Aesthetics aesthetics = rendererData.getAesthetics();
            boolean bl = layer.isYOrientation();
            if (bl) {
                coordinateSystem = coord.flip();
            } else if (!bl) {
                coordinateSystem = coord;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CoordinateSystem coord2 = coordinateSystem;
            GeomTargetCollector it = targetCollector;
            boolean bl2 = false;
            it = flippedAxis2 ? it.withFlippedAxis() : it;
            boolean bl3 = false;
            GeomTargetCollector targetCollector2 = layer.isYOrientation() ? it.withYOrientation() : it;
            ImmutableGeomContext ctx = new GeomContextBuilder().flipped(flippedAxis2).aesthetics(aesthetics).aestheticMappers(aestheticMappers).aesBounds(xyAesBounds).geomTargetCollector(targetCollector2).fontFamilyRegistry(layer.getFontFamilyRegistry()).annotations(rendererData.getAnnotations()).backgroundColor(backgroundColor).build();
            PositionAdjustment pos = rendererData.getPos();
            Geom geom2 = layer.getGeom();
            return new SvgLayerRenderer(aesthetics, geom2, pos, coord2, ctx);
        }

        private final double gridLineDistance(DoubleRectangle geomInnerBounds, DoubleRectangle geomOuterBounds, Orientation orientation) {
            double d;
            switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                case 1: {
                    d = geomInnerBounds.getLeft() - geomOuterBounds.getLeft();
                    break;
                }
                case 2: {
                    d = geomOuterBounds.getRight() - geomInnerBounds.getRight();
                    break;
                }
                case 3: {
                    d = geomInnerBounds.getTop() - geomOuterBounds.getTop();
                    break;
                }
                case 4: {
                    d = geomOuterBounds.getBottom() - geomInnerBounds.getBottom();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return d;
        }

        private static final void buildAxis$drawDebugRect(AxisComponent axis, DoubleRectangle r, Color color) {
            SvgRectElement rect2 = new SvgRectElement(r);
            rect2.strokeColor().set((Object)color);
            rect2.strokeWidth().set((Object)1.0);
            rect2.fillOpacity().set((Object)0.0);
            axis.add((SvgNode)rect2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                try {
                    nArray[Orientation.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.TOP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Orientation.BOTTOM.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

