/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.commons.values.FontFamily;
import org.jetbrains.letsPlot.core.plot.base.layout.Margins;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.presentation.FontFamilyRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u0004H\u0084\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0004J$\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0004H\u0004J\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0004J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0004J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0004J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0004J$\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0004H\u0004J\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0004J\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u0004J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0004H\u0004J\u0016\u0010\u001f\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0016\u0010 \u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "", "values", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;)V", "mem", "", "get", "key", "getBoolean", "", "", "getColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "elem", "getElemValue", "getFontFace", "Lorg/jetbrains/letsPlot/commons/values/FontFace;", "getFontFamily", "Lorg/jetbrains/letsPlot/commons/values/FontFamily;", "getMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Margins;", "getNumber", "", "getTextJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "getTextStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "getValue", "isElemBlank", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nThemeValuesAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeValuesAccess.kt\norg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n361#2,3:131\n364#2,4:135\n361#2,3:139\n364#2,4:149\n1#3:134\n1549#4:142\n1620#4,3:143\n1789#4,3:146\n*S KotlinDebug\n*F\n+ 1 ThemeValuesAccess.kt\norg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess\n*L\n32#1:131,3\n32#1:135,4\n56#1:139,3\n56#1:149,4\n57#1:142\n57#1:143,3\n58#1:146,3\n*E\n"})
public class ThemeValuesAccess {
    @NotNull
    private final Map<String, Object> values;
    @NotNull
    private final FontFamilyRegistry fontFamilyRegistry;
    @NotNull
    private final Map<String, Object> mem;

    public ThemeValuesAccess(@NotNull Map<String, ? extends Object> values, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        this.values = values;
        this.fontFamilyRegistry = fontFamilyRegistry;
        this.mem = new HashMap();
    }

    @Nullable
    protected final Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.values.get(key);
    }

    @NotNull
    protected final Object getValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return MapsKt.getValue(this.values, (Object)key);
    }

    private final Object getValue(List<String> key) {
        String specificOption = (String)CollectionsKt.first(key);
        Map<String, Object> $this$getOrPut$iv = this.mem;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(specificOption);
        if (value$iv == null) {
            Object object;
            block3: {
                boolean bl = false;
                for (String it : (Iterable)key) {
                    boolean bl2 = false;
                    Object object2 = this.values.get(it);
                    if (object2 == null) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            if (object == null) {
                throw new IllegalStateException("No theme value found. Key : " + key + '.');
            }
            return object;
        }
        return value$iv;
    }

    protected final double getNumber(@NotNull List<String> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object value = this.getValue(key);
        Number number = value instanceof Number ? (Number)((Number)value) : (Number)null;
        if (number == null) {
            throw new IllegalStateException("Theme value is not a number: " + value + ". Key : " + key + '.');
        }
        return number.doubleValue();
    }

    protected final boolean getBoolean(@NotNull List<String> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object value = this.getValue(key);
        Boolean bl = value instanceof Boolean ? (Boolean)value : null;
        if (bl == null) {
            throw new IllegalStateException("Theme value is not boolean: " + value + ". Key : " + key + '.');
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, Object> getElemValue(@NotNull List<String> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String specificOption = (String)CollectionsKt.first(key);
        Map<String, Object> $this$getOrPut$iv = this.mem;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(specificOption);
        if (value$iv == null) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = CollectionsKt.asReversed(key);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.values.get(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            HashMap initial$iv = new HashMap();
            boolean $i$f$fold = false;
            HashMap accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                void v;
                Object element$iv;
                Object item$iv$iv;
                item$iv$iv = element$iv = iterator.next();
                HashMap acc = accumulator$iv;
                boolean bl3 = false;
                if (v != null) {
                    acc.putAll((Map)v);
                }
                accumulator$iv = acc;
            }
            return accumulator$iv;
        }
        return (Map)value$iv;
    }

    protected final boolean isElemBlank(@NotNull List<String> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object blankValue = this.getElemValue(key).get("blank");
        return blankValue != null && (Boolean)blankValue != false;
    }

    protected final double getNumber(@NotNull Map<String, ? extends Object> elem, @NotNull String key) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = MapsKt.getValue(elem, (Object)key);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        return ((Number)object).doubleValue();
    }

    @NotNull
    protected final Color getColor(@NotNull Map<String, ? extends Object> elem, @NotNull String key) {
        Color color;
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = MapsKt.getValue(elem, (Object)key);
        if (value instanceof Color) {
            color = (Color)value;
        } else {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            color = Colors.INSTANCE.parseColor((String)value);
        }
        return color;
    }

    @NotNull
    protected final FontFace getFontFace(@NotNull Map<String, ? extends Object> elem) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        Object value = MapsKt.getValue(elem, (Object)"face");
        return value instanceof FontFace ? (FontFace)value : (value instanceof String ? FontFace.Companion.fromString((String)value) : FontFace.Companion.getNORMAL());
    }

    private final FontFamily getFontFamily(Map<String, ? extends Object> elem) {
        String string;
        block3: {
            block2: {
                Object object = MapsKt.getValue(elem, (Object)"family");
                String value = object instanceof String ? (String)object : null;
                string = value;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                FontFamily fontFamily = this.fontFamilyRegistry.get(value);
                string = fontFamily;
                if (fontFamily != null) break block3;
            }
            throw new IllegalStateException("Theme value 'family' is not a string. Elem : " + elem + '.');
        }
        return string;
    }

    @NotNull
    protected final ThemeTextStyle getTextStyle(@NotNull Map<String, ? extends Object> elem) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        return new ThemeTextStyle(this.getFontFamily(elem), this.getFontFace(elem), this.getNumber(elem, "size"), this.getColor(elem, "color"));
    }

    @NotNull
    protected final TextJustification getTextJustification(@NotNull Map<String, ? extends Object> elem) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        double hjust = this.getNumber(elem, "hjust");
        double vjust = this.getNumber(elem, "vjust");
        return new TextJustification(hjust, vjust);
    }

    @NotNull
    protected final Margins getMargins(@NotNull Map<String, ? extends Object> elem) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        return new Margins(this.getNumber(elem, "margin_t"), this.getNumber(elem, "margin_r"), this.getNumber(elem, "margin_b"), this.getNumber(elem, "margin_l"));
    }
}

