/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.Margins;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;
import org.jetbrains.letsPlot.core.plot.builder.presentation.FontFamilyRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020 H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\b\u0010*\u001a\u00020\u001eH\u0016J\b\u0010+\u001a\u00020 H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPlotTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;)V", "backgroundKey", "", "getBackgroundKey$plot_builder", "()Ljava/util/List;", "captionKey", "getCaptionKey$plot_builder", "messagesKey", "getMessagesKey$plot_builder", "subtitleKey", "getSubtitleKey$plot_builder", "titleKey", "getTitleKey$plot_builder", "backgroundColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "backgroundFill", "backgroundStrokeWidth", "", "captionJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "captionMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Margins;", "captionStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "showBackground", "", "showMessage", "subtitleJustification", "subtitleMargins", "subtitleStyle", "textColor", "textStyle", "titleJustification", "titleMargins", "titleStyle", "plot-builder"})
public final class DefaultPlotTheme
extends ThemeValuesAccess
implements PlotTheme {
    @NotNull
    private final List<String> backgroundKey;
    @NotNull
    private final List<String> titleKey;
    @NotNull
    private final List<String> subtitleKey;
    @NotNull
    private final List<String> captionKey;
    @NotNull
    private final List<String> messagesKey;

    public DefaultPlotTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"plot_background", "rect"};
        this.backgroundKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_title", "title", "text"};
        this.titleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_subtitle", "title", "text"};
        this.subtitleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"plot_caption", "title", "text"};
        this.captionKey = CollectionsKt.listOf((Object[])objectArray);
        this.messagesKey = CollectionsKt.listOf((Object)"plot_message");
    }

    @NotNull
    public final List<String> getBackgroundKey$plot_builder() {
        return this.backgroundKey;
    }

    @NotNull
    public final List<String> getTitleKey$plot_builder() {
        return this.titleKey;
    }

    @NotNull
    public final List<String> getSubtitleKey$plot_builder() {
        return this.subtitleKey;
    }

    @NotNull
    public final List<String> getCaptionKey$plot_builder() {
        return this.captionKey;
    }

    @NotNull
    public final List<String> getMessagesKey$plot_builder() {
        return this.messagesKey;
    }

    public boolean showBackground() {
        return !this.isElemBlank(this.backgroundKey);
    }

    @NotNull
    public Color backgroundColor() {
        return this.getColor(this.getElemValue(this.backgroundKey), "color");
    }

    @NotNull
    public Color backgroundFill() {
        return this.getColor(this.getElemValue(this.backgroundKey), "fill");
    }

    public double backgroundStrokeWidth() {
        return this.getNumber(this.getElemValue(this.backgroundKey), "size");
    }

    @NotNull
    public ThemeTextStyle titleStyle() {
        return this.getTextStyle(this.getElemValue(this.titleKey));
    }

    @NotNull
    public ThemeTextStyle subtitleStyle() {
        return this.getTextStyle(this.getElemValue(this.subtitleKey));
    }

    @NotNull
    public ThemeTextStyle captionStyle() {
        return this.getTextStyle(this.getElemValue(this.captionKey));
    }

    @NotNull
    public Color textColor() {
        return this.getColor(this.getElemValue(CollectionsKt.listOf((Object)"text")), "color");
    }

    @NotNull
    public ThemeTextStyle textStyle() {
        return this.getTextStyle(this.getElemValue(CollectionsKt.listOf((Object)"text")));
    }

    @NotNull
    public TextJustification titleJustification() {
        return this.getTextJustification(this.getElemValue(this.titleKey));
    }

    @NotNull
    public TextJustification subtitleJustification() {
        return this.getTextJustification(this.getElemValue(this.subtitleKey));
    }

    @NotNull
    public TextJustification captionJustification() {
        return this.getTextJustification(this.getElemValue(this.captionKey));
    }

    @NotNull
    public Margins titleMargins() {
        return this.getMargins(this.getElemValue(this.titleKey));
    }

    @NotNull
    public Margins subtitleMargins() {
        return this.getMargins(this.getElemValue(this.subtitleKey));
    }

    @NotNull
    public Margins captionMargins() {
        return this.getMargins(this.getElemValue(this.captionKey));
    }

    public boolean showMessage() {
        return !this.isElemBlank(this.messagesKey);
    }
}

