/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.DefaultPanelGridTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;
import org.jetbrains.letsPlot.core.plot.builder.presentation.FontFamilyRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPanelTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;)V", "borderKey", "", "getBorderKey$plot_builder", "()Ljava/util/List;", "gridX", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPanelGridTheme;", "gridY", "rectKey", "getRectKey$plot_builder", "borderColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "borderWidth", "", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "flipAxis", "", "rectColor", "rectFill", "rectStrokeWidth", "showBorder", "showRect", "plot-builder"})
public final class DefaultPanelTheme
extends ThemeValuesAccess
implements PanelTheme {
    @NotNull
    private final DefaultPanelGridTheme gridX;
    @NotNull
    private final DefaultPanelGridTheme gridY;
    @NotNull
    private final List<String> rectKey;
    @NotNull
    private final List<String> borderKey;

    public DefaultPanelTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        this.gridX = new DefaultPanelGridTheme("x", options, fontFamilyRegistry);
        this.gridY = new DefaultPanelGridTheme("y", options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"panel_background", "rect"};
        this.rectKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"panel_border", "rect"};
        this.borderKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getRectKey$plot_builder() {
        return this.rectKey;
    }

    @NotNull
    public final List<String> getBorderKey$plot_builder() {
        return this.borderKey;
    }

    public boolean showRect() {
        return !this.isElemBlank(this.rectKey);
    }

    @NotNull
    public Color rectColor() {
        return this.getColor(this.getElemValue(this.rectKey), "color");
    }

    @NotNull
    public Color rectFill() {
        return this.getColor(this.getElemValue(this.rectKey), "fill");
    }

    public double rectStrokeWidth() {
        return this.getNumber(this.getElemValue(this.rectKey), "size");
    }

    public boolean showBorder() {
        return !this.isElemBlank(this.borderKey);
    }

    @NotNull
    public Color borderColor() {
        return this.getColor(this.getElemValue(this.borderKey), "color");
    }

    public double borderWidth() {
        return this.getNumber(this.getElemValue(this.borderKey), "size");
    }

    @NotNull
    public PanelGridTheme gridX(boolean flipAxis) {
        return flipAxis ? (PanelGridTheme)this.gridY : (PanelGridTheme)this.gridX;
    }

    @NotNull
    public PanelGridTheme gridY(boolean flipAxis) {
        return flipAxis ? (PanelGridTheme)this.gridX : (PanelGridTheme)this.gridY;
    }
}

