/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;
import org.jetbrains.letsPlot.core.plot.builder.presentation.FontFamilyRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPanelGridTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "axis", "", "options", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;", "(Ljava/lang/String;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/builder/presentation/FontFamilyRegistry;)V", "majorLineKey", "", "getMajorLineKey$plot_builder", "()Ljava/util/List;", "minorLineKey", "getMinorLineKey$plot_builder", "suffix", "majorLineColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "majorLineWidth", "", "minorLineColor", "minorLineWidth", "showMajor", "", "showMinor", "plot-builder"})
public final class DefaultPanelGridTheme
extends ThemeValuesAccess
implements PanelGridTheme {
    @NotNull
    private final String suffix;
    @NotNull
    private final List<String> majorLineKey;
    @NotNull
    private final List<String> minorLineKey;

    public DefaultPanelGridTheme(@NotNull String axis, @NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        this.suffix = '_' + axis;
        Object[] objectArray = new String[]{"panel_grid_major" + this.suffix, "panel_grid_major", "panel_grid" + this.suffix, "panel_grid", "line"};
        this.majorLineKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"panel_grid_minor" + this.suffix, "panel_grid_minor", "panel_grid" + this.suffix, "panel_grid", "line"};
        this.minorLineKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getMajorLineKey$plot_builder() {
        return this.majorLineKey;
    }

    @NotNull
    public final List<String> getMinorLineKey$plot_builder() {
        return this.minorLineKey;
    }

    public boolean showMajor() {
        return !this.isElemBlank(this.majorLineKey);
    }

    public boolean showMinor() {
        return !this.isElemBlank(this.minorLineKey);
    }

    public double majorLineWidth() {
        return this.getNumber(this.getElemValue(this.majorLineKey), "size");
    }

    public double minorLineWidth() {
        return this.getNumber(this.getElemValue(this.minorLineKey), "size");
    }

    @NotNull
    public Color majorLineColor() {
        return this.getColor(this.getElemValue(this.majorLineKey), "color");
    }

    @NotNull
    public Color minorLineColor() {
        return this.getColor(this.getElemValue(this.minorLineKey), "color");
    }
}

