/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.Stat;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;
import org.jetbrains.letsPlot.core.plot.builder.VarBinding;
import org.jetbrains.letsPlot.core.plot.builder.data.GroupMapperHelper;
import org.jetbrains.letsPlot.core.plot.builder.data.GroupMerger;
import org.jetbrains.letsPlot.core.plot.builder.data.GroupUtil;
import org.jetbrains.letsPlot.core.plot.builder.data.GroupingContext;
import org.jetbrains.letsPlot.core.plot.builder.data.OrderOptionUtil;
import org.jetbrains.letsPlot.core.plot.builder.data.StatInput;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0080\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u001c\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0014`\u0018H\u0002J\u0086\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\t2\u001e\u0010!\u001a\u001a\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\t\u0012\u0006\u0012\u0004\u0018\u00010\"\u0018\u00010\u00162\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0014`\u0018J*\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\tH\u0002J(\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\t2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+H\u0002J/\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0\u00162\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u0000\u00a2\u0006\u0002\b-J$\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J,\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u00100\u001a\u0004\u0018\u00010\u0014J!\u00101\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b3J>\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J$\u00106\u001a\u0002072\u0006\u0010\u0005\u001a\u00020\u00042\n\u00108\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u00109\u001a\u00020\u0010H\u0002J0\u0010:\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0\u0016H\u0002J4\u0010<\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\f\u00a8\u0006>"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/data/DataProcessing;", "", "()V", "applyStat", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "stat", "Lorg/jetbrains/letsPlot/core/plot/base/Stat;", "bindings", "", "Lorg/jetbrains/letsPlot/core/plot/builder/VarBinding;", "transformByAes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "facetVariables", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "varsWithoutBinding", "", "compMessageConsumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "buildStatData", "Lorg/jetbrains/letsPlot/core/plot/builder/data/DataProcessing$DataAndGroupMapper;", "statInput", "Lorg/jetbrains/letsPlot/core/plot/builder/data/StatInput;", "groupingContext", "Lorg/jetbrains/letsPlot/core/plot/builder/data/GroupingContext;", "orderOptions", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "aggregateOperation", "", "messageConsumer", "computeDummyValues", "", "list1", "list2", "computeGroups", "values", "distinctValues", "", "groupingVariables", "computeGroups$plot_builder", "defaultGroupingVariables", "", "pathIdVarName", "findOptionalVariable", "name", "findOptionalVariable$plot_builder", "inverseTransformStatData", "statData", "isDefaultGroupingVariable", "", "aes", "variable", "splitByGroup", "groups", "transformOriginals", "DataAndGroupMapper", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nDataProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataProcessing.kt\norg/jetbrains/letsPlot/core/plot/builder/data/DataProcessing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,446:1\n1271#2,2:447\n1285#2,4:449\n766#2:454\n857#2,2:455\n1238#2,2:459\n1789#2,3:461\n1241#2:464\n1271#2,2:465\n1285#2,4:467\n1271#2,2:471\n1285#2,4:473\n819#2:477\n847#2,2:478\n1747#2,3:482\n1747#2,3:485\n766#2:488\n857#2,2:489\n1194#2,2:491\n1222#2,4:493\n766#2:497\n857#2,2:498\n1179#2,2:500\n1253#2,4:502\n766#2:506\n857#2,2:507\n766#2:509\n857#2,2:510\n1271#2,2:512\n1285#2,4:514\n766#2:520\n857#2,2:521\n1549#2:523\n1620#2,3:524\n1#3:453\n442#4:457\n392#4:458\n215#5,2:480\n215#5,2:518\n*S KotlinDebug\n*F\n+ 1 DataProcessing.kt\norg/jetbrains/letsPlot/core/plot/builder/data/DataProcessing\n*L\n81#1:447,2\n81#1:449,4\n129#1:454\n129#1:455,2\n189#1:459,2\n190#1:461,3\n189#1:464\n233#1:465,2\n233#1:467,4\n234#1:471,2\n234#1:473,4\n266#1:477\n266#1:478,2\n302#1:482,3\n303#1:485,3\n316#1:488\n316#1:489,2\n316#1:491,2\n316#1:493,4\n319#1:497\n319#1:498,2\n319#1:500,2\n319#1:502,4\n325#1:506\n325#1:507,2\n327#1:509\n327#1:510,2\n330#1:512,2\n330#1:514,4\n425#1:520\n425#1:521,2\n426#1:523\n426#1:524,3\n189#1:457\n189#1:458\n274#1:480,2\n339#1:518,2\n*E\n"})
public final class DataProcessing {
    @NotNull
    public static final DataProcessing INSTANCE = new DataProcessing();

    private DataProcessing() {
    }

    @NotNull
    public final DataFrame transformOriginals(@NotNull DataFrame data, @NotNull List<VarBinding> bindings, @NotNull Map<Aes<?>, ? extends Transform> transformByAes) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        Intrinsics.checkNotNullParameter(transformByAes, (String)"transformByAes");
        DataFrame data2 = data;
        for (VarBinding binding : bindings) {
            DataFrame.Variable variable = binding.getVariable();
            if (!variable.isOrigin()) continue;
            data2.assertDefined(variable);
            data2 = DataFrameUtil.INSTANCE.applyTransform(data2, variable, binding.getAes(), (Transform)MapsKt.getValue(transformByAes, binding.getAes()));
        }
        return data2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataAndGroupMapper buildStatData(@NotNull StatInput statInput, @NotNull Stat stat, @NotNull GroupingContext groupingContext, @NotNull List<DataFrame.Variable> facetVariables, @NotNull List<String> varsWithoutBinding, @NotNull List<OrderOptionUtil.OrderOption> orderOptions, @Nullable Function1<? super List<Double>, Double> aggregateOperation, @NotNull Function1<? super String, Unit> messageConsumer) {
        ArrayList<Double> arrayList;
        String variable;
        Map map2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)statInput, (String)"statInput");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        Intrinsics.checkNotNullParameter((Object)groupingContext, (String)"groupingContext");
        Intrinsics.checkNotNullParameter(facetVariables, (String)"facetVariables");
        Intrinsics.checkNotNullParameter(varsWithoutBinding, (String)"varsWithoutBinding");
        Intrinsics.checkNotNullParameter(orderOptions, (String)"orderOptions");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!(!Intrinsics.areEqual((Object)stat, (Object)Stats.INSTANCE.getIDENTITY()))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Function1<Integer, Integer> groups = groupingContext.getGroupMapper();
        Map resultSeries = null;
        List<Integer> groupSizeListAfterStat = null;
        if (groups == GroupMapperHelper.INSTANCE.getSINGLE_GROUP()) {
            DataFrame statData = this.applyStat(statInput.getData(), stat, statInput.getBindings(), statInput.getTransformByAes(), facetVariables, statInput.getStatCtx(), varsWithoutBinding, messageConsumer);
            groupSizeListAfterStat = CollectionsKt.listOf((Object)statData.rowCount());
            Iterable $this$associateWith$iv = statData.variables();
            boolean $i$f$associateWith = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                DataFrame.Variable variable2 = (DataFrame.Variable)element$iv$iv;
                object = element$iv$iv;
                map2 = linkedHashMap;
                boolean bl = false;
                arrayList = statData.get((DataFrame.Variable)variable);
                map2.put(object, arrayList);
            }
            resultSeries = linkedHashMap;
        } else {
            GroupMerger groupMerger = new GroupMerger(aggregateOperation);
            int lastStatGroupEnd = -1;
            for (Map.Entry<Integer, DataFrame> entry : this.splitByGroup(statInput.getData(), groups).entrySet()) {
                ArrayList<Double> newG;
                int groupId = ((Number)entry.getKey()).intValue();
                DataFrame d = entry.getValue();
                DataFrame statData = this.applyStat(d, stat, statInput.getBindings(), statInput.getTransformByAes(), facetVariables, statInput.getStatCtx(), varsWithoutBinding, messageConsumer);
                if (!(!statData.isEmpty())) {
                    variable = "Check failed.";
                    throw new IllegalStateException(variable.toString());
                }
                int curGroupSizeAfterStat = statData.rowCount();
                if (statData.has(Stats.INSTANCE.getGROUP())) {
                    DoubleSpan range = statData.range(Stats.INSTANCE.getGROUP());
                    if (range != null) {
                        int start = lastStatGroupEnd + 1;
                        int offset = start - (int)range.getLowerEnd().doubleValue();
                        lastStatGroupEnd = (int)range.getUpperEnd().doubleValue() + offset;
                        if (offset != 0) {
                            newG = new ArrayList();
                            Iterator iterator = statData.getNumeric(Stats.INSTANCE.getGROUP()).iterator();
                            while (iterator.hasNext()) {
                                Double g;
                                Double d2 = g = (Double)iterator.next();
                                Intrinsics.checkNotNull((Object)d2);
                                newG.add(d2 + (double)offset);
                            }
                            statData = statData.builder().putNumeric(Stats.INSTANCE.getGROUP(), (List)newG).build();
                        }
                    }
                } else {
                    DataFrame.Variable groupingVar = groupingContext.getOptionalGroupingVar$plot_builder();
                    if (groupingVar != null) {
                        int size = statData.get((DataFrame.Variable)CollectionsKt.first((Iterable)statData.variables())).size();
                        Object v = d.get(groupingVar).get(0);
                        object = groupingVar;
                        map2 = statData.builder();
                        newG = new ArrayList<Double>(size);
                        int n = 0;
                        while (n < size) {
                            int g;
                            int n2 = g = n++;
                            arrayList = newG;
                            boolean bl = false;
                            arrayList.add((Double)v);
                        }
                        arrayList = newG;
                        statData = map2.put((DataFrame.Variable)object, arrayList).build();
                    }
                }
                if (groupMerger.isEmpty()) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable size = orderOptions;
                    boolean $i$f$filter = false;
                    newG = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Object v1;
                        block17: {
                            OrderOptionUtil.OrderOption orderOption = (OrderOptionUtil.OrderOption)element$iv$iv;
                            boolean bl = false;
                            Iterable iterable = statInput.getBindings();
                            for (Object t : iterable) {
                                VarBinding it = (VarBinding)t;
                                boolean bl2 = false;
                                if (!(Intrinsics.areEqual((Object)it.getVariable().getName(), (Object)orderOption.getVariableName()) && Intrinsics.areEqual(it.getAes(), (Object)Aes.Companion.getX()))) continue;
                                v1 = t;
                                break block17;
                            }
                            v1 = null;
                        }
                        boolean bl = v1 == null;
                        if (!bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List orderOptionsMinusX = (List)destination$iv$iv;
                    groupMerger.setOrderSpecs(OrderOptionUtil.INSTANCE.createOrderSpecs(orderOptionsMinusX, (Set<DataFrame.Variable>)statData.variables(), statInput.getBindings(), aggregateOperation));
                }
                groupMerger.addGroup(groupId, statData, curGroupSizeAfterStat);
            }
            resultSeries = groupMerger.getResultSeries();
            groupSizeListAfterStat = groupMerger.getGroupSizes();
        }
        DataFrame.Builder $this$buildStatData_u24lambda_u244 = new DataFrame.Builder();
        boolean bl = false;
        for (DataFrame.Variable variable3 : resultSeries.keySet()) {
            List<Object> list = resultSeries.get(variable3);
            Intrinsics.checkNotNull(list);
            $this$buildStatData_u24lambda_u244.put(variable3, list);
        }
        List<DataFrame.OrderSpec> orderSpecs = OrderOptionUtil.INSTANCE.createOrderSpecs(orderOptions, resultSeries.keySet(), statInput.getBindings(), aggregateOperation);
        $this$buildStatData_u24lambda_u244.addOrderSpecs(orderSpecs);
        DataFrame dataAfterStat = $this$buildStatData_u24lambda_u244.build();
        DataFrame normalizedData = stat.normalize(dataAfterStat);
        return new DataAndGroupMapper(normalizedData, GroupMapperHelper.INSTANCE.createGroupMapperByGroupSizes(normalizedData, groupSizeListAfterStat));
    }

    @Nullable
    public final DataFrame.Variable findOptionalVariable$plot_builder(@NotNull DataFrame data, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CharSequence charSequence = name;
        return charSequence == null || charSequence.length() == 0 ? null : DataFrameUtil.INSTANCE.findVariableOrFail(data, name);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, DataFrame> splitByGroup(DataFrame data, Function1<? super Integer, Integer> groups) {
        void $this$mapValuesTo$iv$iv;
        Map<Integer, List<Integer>> indicesByGroup;
        Map<Integer, List<Integer>> $this$mapValues$iv = indicesByGroup = GroupUtil.INSTANCE.indicesByGroup(data.rowCount(), groups);
        boolean $i$f$mapValues = false;
        Map<Integer, List<Integer>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$fold$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List indices = (List)entry2.getValue();
            Iterable iterable = data.variables();
            DataFrame.Builder initial$iv = new DataFrame.Builder();
            boolean $i$f$fold = false;
            DataFrame.Builder accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                DataFrame.Builder builder;
                void variable;
                DataFrame.Variable variable2 = (DataFrame.Variable)element$iv;
                DataFrame.Builder b = accumulator$iv;
                boolean bl3 = false;
                boolean bl4 = data.isNumeric((DataFrame.Variable)variable);
                if (bl4) {
                    builder = b.putNumeric((DataFrame.Variable)variable, CollectionsKt.slice((List)data.getNumeric((DataFrame.Variable)variable), (Iterable)indices));
                } else if (!bl4) {
                    builder = b.putDiscrete((DataFrame.Variable)variable, CollectionsKt.slice((List)data.get((DataFrame.Variable)variable), (Iterable)indices));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                accumulator$iv = builder;
            }
            DataFrame.Builder builder = accumulator$iv;
            DataFrame dataFrame = builder.build();
            map4.put(k, dataFrame);
        }
        Map dataByGroup = destination$iv$iv;
        return dataByGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final DataFrame applyStat(DataFrame data, Stat stat, List<VarBinding> bindings, Map<Aes<?>, ? extends Transform> transformByAes, List<DataFrame.Variable> facetVariables, StatContext statCtx, List<String> varsWithoutBinding, Function1<? super String, Unit> compMessageConsumer) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Stats variable;
        Map map2;
        List list;
        Map map3;
        Object t;
        boolean $i$f$associateWithTo;
        Iterable $this$associateWithTo$iv$iv;
        LinkedHashMap result$iv;
        boolean $i$f$associateWith;
        Iterator $this$associateWith$iv;
        DataFrame statData = stat.apply(data, statCtx, compMessageConsumer);
        Set statVariables = statData.variables();
        if (statVariables.isEmpty()) {
            return statData;
        }
        int statDataSize = (statData = this.inverseTransformStatData(statData, stat, bindings, transformByAes)).rowCount();
        if (statDataSize == 0) {
            $this$associateWith$iv = facetVariables;
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                DataFrame.Variable variable2 = (DataFrame.Variable)element$iv$iv;
                t = element$iv$iv;
                map3 = result$iv;
                boolean bl = false;
                list = CollectionsKt.emptyList();
                map3.put(t, list);
            }
            map2 = result$iv;
        } else {
            $this$associateWith$iv = facetVariables;
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
                t = element$iv$iv;
                map3 = result$iv;
                boolean bl = false;
                Object facetLevel = data.get(it).get(0);
                boolean bl2 = false;
                ArrayList arrayList = new ArrayList(statDataSize);
                int n = 0;
                while (n < statDataSize) {
                    int n2;
                    int n3 = n2 = n++;
                    ArrayList arrayList2 = arrayList;
                    boolean bl3 = false;
                    arrayList2.add(facetLevel);
                }
                list = arrayList;
                map3.put(t, list);
            }
            map2 = result$iv;
        }
        Map inputSeriesForFacetVars = map2;
        HashMap newInputSeries = new HashMap();
        for (VarBinding binding : bindings) {
            variable = binding.getVariable();
            if (variable.isStat() || facetVariables.contains(variable)) continue;
            Aes<?> aes = binding.getAes();
            if (stat.hasDefaultMapping(aes)) {
                DataFrame.Variable defaultStatVar = stat.getDefaultMapping(aes);
                ((Map)newInputSeries).put(variable, statData.get(defaultStatVar));
                continue;
            }
            if (newInputSeries.containsKey(variable)) continue;
            ((Map)newInputSeries).put(variable, DataProcessing.applyStat$newSerieForVariable(data, statDataSize, (DataFrame.Variable)variable));
        }
        Iterable binding = varsWithoutBinding;
        variable = Stats.INSTANCE;
        boolean $i$f$filterNot = false;
        void defaultStatVar = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (variable.isStatVar(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String varName : (List)destination$iv$iv) {
            variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, varName);
            if (newInputSeries.containsKey(variable)) continue;
            ((Map)newInputSeries).put(variable, DataProcessing.applyStat$newSerieForVariable(data, statDataSize, (DataFrame.Variable)variable));
        }
        DataFrame.Builder b = statData.builder();
        Map $this$forEach$iv = MapsKt.plus((Map)newInputSeries, (Map)inputSeriesForFacetVars);
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl = false;
            DataFrame.Variable variable3 = (DataFrame.Variable)entry.getKey();
            List serie = (List)entry.getValue();
            b.put(variable3, serie);
        }
        return b.build();
    }

    /*
     * WARNING - void declaration
     */
    private final DataFrame inverseTransformStatData(DataFrame statData, Stat stat, List<VarBinding> bindings, Map<Aes<?>, ? extends Transform> transformByAes) {
        void $this$associateWith$iv;
        Aes aes;
        DataFrame.Variable it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv3;
        Iterable $this$filter$iv3;
        boolean bl;
        boolean needTransformX;
        block17: {
            boolean bl2;
            block16: {
                if (!transformByAes.containsKey(Aes.Companion.getX())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!transformByAes.containsKey(Aes.Companion.getY())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Iterable $this$any$iv = stat.consumes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Aes it2 = (Aes)element$iv;
                        boolean bl3 = false;
                        if (!Aes.Companion.isPositionalX(it2)) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            needTransformX = bl2;
            Iterable $this$any$iv = stat.consumes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Aes it3 = (Aes)element$iv;
                    boolean bl4 = false;
                    if (!Aes.Companion.isPositionalY(it3)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean needTransformY = bl;
        Object $this$inverseTransformStatData_u24lambda_u2419 = this;
        boolean bl5 = false;
        Iterable it3 = Aes.Companion.values();
        boolean $i$f$filter = false;
        void var13_25 = $this$filter$iv3;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            Aes it4 = (Aes)element$iv$iv;
            boolean bl6 = false;
            if (!stat.hasDefaultMapping(it4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it5;
            Aes bl6 = (Aes)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl7 = false;
            map2.put(stat.getDefaultMapping((Aes)it5), element$iv$iv);
        }
        Map aesByStatVarDefault = destination$iv$iv2;
        Iterable $i$f$associateBy22 = bindings;
        boolean $i$f$filter2 = false;
        $this$associateByTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VarBinding it6 = (VarBinding)element$iv$iv;
            boolean bl8 = false;
            if (!it6.getVariable().isStat()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv3;
            VarBinding it7 = (VarBinding)element$iv$iv;
            boolean bl9 = false;
            Pair pair = TuplesKt.to((Object)it7.getVariable(), it7.getAes());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map aesByStatVarMapped = destination$iv$iv3;
        Map aesByStatVar = MapsKt.plus((Map)aesByStatVarDefault, (Map)aesByStatVarMapped);
        $this$inverseTransformStatData_u24lambda_u2419 = statData.variables();
        boolean $i$f$filter3 = false;
        aesByStatVarMapped = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl10 = false;
            if (!aesByStatVar.containsKey(it)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        $i$f$filter3 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv4 = new ArrayList();
        $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl11 = false;
            aes = (Aes)MapsKt.getValue((Map)aesByStatVar, (Object)it);
            if (!DataProcessing.inverseTransformStatData$needInverseTransform(needTransformX, needTransformY, aes)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            Object t = element$iv$iv;
            Map map4 = result$iv;
            boolean bl12 = false;
            aes = (Aes)MapsKt.getValue((Map)aesByStatVar, (Object)it);
            Transform transform = DataProcessing.inverseTransformStatData$transformForAes(transformByAes, aes);
            List statSerie = statData.getNumeric(it);
            List list = transform.applyInverse(statSerie);
            map4.put(t, list);
        }
        Map inverseTransformedSeries = result$iv;
        DataFrame.Builder builder = statData.builder();
        Map $this$forEach$iv = inverseTransformedSeries;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl13 = false;
            DataFrame.Variable variable = (DataFrame.Variable)entry.getKey();
            List serie = (List)entry.getValue();
            builder.put(variable, serie);
        }
        return builder.build();
    }

    @NotNull
    public final Function1<Integer, Integer> computeGroups$plot_builder(@NotNull DataFrame data, @NotNull List<DataFrame.Variable> groupingVariables) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(groupingVariables, (String)"groupingVariables");
        List<Integer> currentGroups = null;
        for (DataFrame.Variable groupingVariable : groupingVariables) {
            List values = data.get(groupingVariable);
            Collection distinctValues = data.distinctValues(groupingVariable);
            List<Integer> groups = this.computeGroups(values, distinctValues);
            if (currentGroups == null) {
                currentGroups = groups;
                continue;
            }
            if (!(currentGroups.size() == groups.size())) {
                boolean bl = false;
                String string = "Data series used to compute groups must be equal in size (encountered sizes: " + Integer.valueOf(currentGroups.size()) + ", " + groups.size() + " )";
                throw new IllegalStateException(string.toString());
            }
            List<Integer> dummies = this.computeDummyValues(currentGroups, groups);
            currentGroups = this.computeGroups(dummies, CollectionsKt.toSet((Iterable)dummies));
        }
        return currentGroups != null ? GroupMapperHelper.INSTANCE.wrap(currentGroups) : GroupMapperHelper.INSTANCE.getSINGLE_GROUP();
    }

    private final List<Integer> computeGroups(List<?> values, Collection<? extends Object> distinctValues) {
        HashMap groupByVal = new HashMap();
        Iterator<? extends Object> iterator = distinctValues.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Object distinctValue = iterator.next();
            Integer n2 = index;
            ((Map)groupByVal).put(distinctValue, n2);
        }
        int groupCount2 = groupByVal.size();
        ArrayList<Object> groups = new ArrayList<Object>();
        for (Object v : values) {
            if (!groupByVal.containsKey(v)) {
                ((Map)groupByVal).put(v, groupCount2++);
            }
            groups.add(MapsKt.getValue((Map)groupByVal, v));
        }
        return groups;
    }

    private final List<Integer> computeDummyValues(List<Integer> list1, List<Integer> list2) {
        if (list1.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int limit = 1000;
        Comparable comparable = CollectionsKt.maxOrNull((Iterable)CollectionsKt.plus((Collection)list1, (Iterable)list2));
        Intrinsics.checkNotNull((Object)comparable);
        int max = ((Number)((Object)comparable)).intValue();
        if (!(max < limit)) {
            boolean $i$a$-check-DataProcessing$computeDummyValues$22 = false;
            String $i$a$-check-DataProcessing$computeDummyValues$22 = "Too many groups: " + max;
            throw new IllegalStateException($i$a$-check-DataProcessing$computeDummyValues$22.toString());
        }
        ArrayList<Integer> dummies = new ArrayList<Integer>();
        Iterator<Integer> it1 = list1.iterator();
        Iterator<Integer> it2 = list2.iterator();
        while (it1.hasNext()) {
            int v1 = ((Number)it1.next()).intValue();
            int v2 = ((Number)it2.next()).intValue();
            int dummy = v1 * limit + v2;
            dummies.add(dummy);
        }
        return dummies;
    }

    @NotNull
    public final List<DataFrame.Variable> defaultGroupingVariables(@NotNull DataFrame data, @NotNull List<VarBinding> bindings, @Nullable String pathIdVarName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        DataFrame.Variable pathIdVar = this.findOptionalVariable$plot_builder(data, pathIdVarName);
        return CollectionsKt.plus(this.defaultGroupingVariables(data, bindings), (Iterable)CollectionsKt.listOfNotNull((Object)pathIdVar));
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<DataFrame.Variable> defaultGroupingVariables(DataFrame data, List<VarBinding> bindings) {
        void $this$mapTo$iv$iv;
        VarBinding it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = bindings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VarBinding)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isDefaultGroupingVariable(data, it.getAes(), it.getVariable())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VarBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVariable());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final boolean isDefaultGroupingVariable(DataFrame data, Aes<?> aes, DataFrame.Variable variable) {
        return variable.isOrigin() && !Aes.Companion.isPositional(aes) && data.isDiscrete(variable);
    }

    private static final List<Object> applyStat$newSerieForVariable(DataFrame $data, int statDataSize, DataFrame.Variable variable) {
        Object object;
        boolean bl = $data.isNumeric(variable);
        if (bl) {
            object = SeriesUtil.INSTANCE.mean($data.getNumeric(variable), null);
        } else if (!bl) {
            object = SeriesUtil.INSTANCE.firstNotNull($data.get(variable), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Double value = object;
        ArrayList<Double> arrayList = new ArrayList<Double>(statDataSize);
        int n = 0;
        while (n < statDataSize) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl2 = false;
            arrayList2.add(value);
        }
        return arrayList;
    }

    private static final Transform inverseTransformStatData$transformForAes(Map<Aes<?>, ? extends Transform> $transformByAes, Aes<?> aes) {
        Transform transform;
        if (Aes.Companion.isPositionalX(aes)) {
            transform = (Transform)MapsKt.getValue($transformByAes, (Object)Aes.Companion.getX());
        } else if (Aes.Companion.isPositionalY(aes)) {
            transform = (Transform)MapsKt.getValue($transformByAes, (Object)Aes.Companion.getY());
        } else {
            throw new IllegalStateException("Positional aes expected but was " + aes + '.');
        }
        return transform;
    }

    private static final boolean inverseTransformStatData$needInverseTransform(boolean needTransformX, boolean needTransformY, Aes<?> aes) {
        if (Aes.Companion.isPositionalX(aes)) {
            return needTransformX;
        }
        if (Aes.Companion.isPositionalY(aes)) {
            return needTransformY;
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/data/DataProcessing$DataAndGroupMapper;", "", "data", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "groupMapper", "Lkotlin/Function1;", "", "(Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;Lkotlin/jvm/functions/Function1;)V", "getData", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "getGroupMapper", "()Lkotlin/jvm/functions/Function1;", "plot-builder"})
    public static final class DataAndGroupMapper {
        @NotNull
        private final DataFrame data;
        @NotNull
        private final Function1<Integer, Integer> groupMapper;

        public DataAndGroupMapper(@NotNull DataFrame data, @NotNull Function1<? super Integer, Integer> groupMapper2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
            this.data = data;
            this.groupMapper = groupMapper2;
        }

        @NotNull
        public final DataFrame getData() {
            return this.data;
        }

        @NotNull
        public final Function1<Integer, Integer> getGroupMapper() {
            return this.groupMapper;
        }
    }
}

