/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/FixedRatioCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "ratio", "", "xLim", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yLim", "flipped", "", "(DLorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Z)V", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "vDomain", "geomSize", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
public class FixedRatioCoordProvider
extends CoordProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ratio;

    public FixedRatioCoordProvider(double ratio, @Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        super(xLim, yLim, flipped, null, 8, null);
        this.ratio = ratio;
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        return new FixedRatioCoordProvider(this.ratio, xLim, yLim, flipped);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double domainRatio = hDomain.getLength() / vDomain.getLength();
        double effectiveDomainRatio = domainRatio / this.ratio;
        return Companion.reshapeGeom(geomSize, effectiveDomainRatio);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/FixedRatioCoordProvider$Companion;", "", "()V", "reshapeGeom", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "geomSize", "targetWidthToHeightRatio", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector reshapeGeom(@NotNull DoubleVector geomSize, double targetWidthToHeightRatio) {
            DoubleVector doubleVector;
            Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
            double geomRatio = geomSize.getX() / geomSize.getY();
            if (targetWidthToHeightRatio > geomRatio) {
                double h = geomSize.getX() / targetWidthToHeightRatio;
                doubleVector = new DoubleVector(geomSize.getX(), h);
            } else {
                double w = geomSize.getY() * targetWidthToHeightRatio;
                doubleVector = new DoubleVector(w, geomSize.getY());
            }
            DoubleVector newSize = doubleVector;
            return newSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

