/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.DragFeedback;
import org.jetbrains.letsPlot.core.interact.EventsManager;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;
import org.jetbrains.letsPlot.core.interact.ToolInteractor;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetLocator;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipRenderer;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00011B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010 \u001a\u00020!H\u0016JB\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0%2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "Lorg/jetbrains/letsPlot/core/interact/ToolInteractor;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "decorationLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flippedAxis", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "getDecorationLayer", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "eventsManager", "Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "getEventsManager", "()Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "geomBoundsList", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lkotlin/collections/ArrayList;", "getPlotSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "reg", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "tooltipRenderer", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/TooltipRenderer;", "dispose", "", "onTileAdded", "geomBounds", "targetLocators", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetLocator;", "layerYOrientations", "axisOrigin", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "startToolFeedback", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "toolFeedback", "Lorg/jetbrains/letsPlot/core/interact/ToolFeedback;", "DragInteractionContext", "plot-builder"})
public final class PlotInteractor
implements ToolInteractor,
Disposable {
    @NotNull
    private final SvgNode decorationLayer;
    @NotNull
    private final DoubleVector plotSize;
    @NotNull
    private final EventsManager eventsManager;
    @NotNull
    private final CompositeRegistration reg;
    @NotNull
    private final TooltipRenderer tooltipRenderer;
    @NotNull
    private final ArrayList<DoubleRectangle> geomBoundsList;

    public PlotInteractor(@NotNull SvgNode decorationLayer, @NotNull MouseEventPeer mouseEventPeer, @NotNull DoubleVector plotSize, boolean flippedAxis, @NotNull Theme theme, @NotNull PlotContext plotContext) {
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        this.decorationLayer = decorationLayer;
        this.plotSize = plotSize;
        this.eventsManager = new EventsManager();
        this.reg = new CompositeRegistration(new Registration[0]);
        this.geomBoundsList = new ArrayList();
        this.reg.add(Registration.Companion.from((Disposable)this.eventsManager));
        this.eventsManager.setEventSource((MouseEventSource)mouseEventPeer);
        this.tooltipRenderer = new TooltipRenderer(this.decorationLayer, flippedAxis, this.plotSize, theme.horizontalAxis(flippedAxis), theme.verticalAxis(flippedAxis), theme.tooltips(), theme.plot().backgroundFill(), plotContext, mouseEventPeer);
        this.reg.add(Registration.Companion.from((Disposable)this.tooltipRenderer));
    }

    @NotNull
    public final SvgNode getDecorationLayer() {
        return this.decorationLayer;
    }

    @NotNull
    public final DoubleVector getPlotSize() {
        return this.plotSize;
    }

    @NotNull
    public final EventsManager getEventsManager() {
        return this.eventsManager;
    }

    public final void onTileAdded(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
        this.tooltipRenderer.addTileInfo(geomBounds, targetLocators, layerYOrientations, axisOrigin, hAxisTooltipPosition, vAxisTooltipPosition);
        this.geomBoundsList.add(geomBounds);
    }

    @NotNull
    public Registration startToolFeedback(@NotNull ToolFeedback toolFeedback) {
        Intrinsics.checkNotNullParameter((Object)toolFeedback, (String)"toolFeedback");
        if (!(toolFeedback instanceof DragFeedback)) {
            throw new IllegalArgumentException("Unknown tool feedback type: " + Reflection.getOrCreateKotlinClass(toolFeedback.getClass()).getSimpleName());
        }
        Disposable disposable = ((DragFeedback)toolFeedback).start((InteractionContext)new DragInteractionContext(this.decorationLayer, this.eventsManager, (List<DoubleRectangle>)this.geomBoundsList));
        return Registration.Companion.from(disposable);
    }

    public void dispose() {
        this.reg.dispose();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor$DragInteractionContext;", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "decorationsLayer", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "eventsManager", "Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "geomBoundsList", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;Lorg/jetbrains/letsPlot/core/interact/EventsManager;Ljava/util/List;)V", "getDecorationsLayer", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "getEventsManager", "()Lorg/jetbrains/letsPlot/core/interact/EventsManager;", "getGeomBoundsList", "()Ljava/util/List;", "findTarget", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "plotCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPlotInteractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotInteractor.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotInteractor$DragInteractionContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    private static final class DragInteractionContext
    implements InteractionContext {
        @NotNull
        private final SvgNode decorationsLayer;
        @NotNull
        private final EventsManager eventsManager;
        @NotNull
        private final List<DoubleRectangle> geomBoundsList;

        public DragInteractionContext(@NotNull SvgNode decorationsLayer, @NotNull EventsManager eventsManager, @NotNull List<DoubleRectangle> geomBoundsList) {
            Intrinsics.checkNotNullParameter((Object)decorationsLayer, (String)"decorationsLayer");
            Intrinsics.checkNotNullParameter((Object)eventsManager, (String)"eventsManager");
            Intrinsics.checkNotNullParameter(geomBoundsList, (String)"geomBoundsList");
            this.decorationsLayer = decorationsLayer;
            this.eventsManager = eventsManager;
            this.geomBoundsList = geomBoundsList;
        }

        @NotNull
        public SvgNode getDecorationsLayer() {
            return this.decorationsLayer;
        }

        @NotNull
        public EventsManager getEventsManager() {
            return this.eventsManager;
        }

        @NotNull
        public final List<DoubleRectangle> getGeomBoundsList() {
            return this.geomBoundsList;
        }

        @Nullable
        public InteractionTarget findTarget(@NotNull DoubleVector plotCoord) {
            InteractionTarget interactionTarget;
            DoubleRectangle geomBounds;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
                Iterable iterable = this.geomBoundsList;
                for (Object t : iterable) {
                    DoubleRectangle it = (DoubleRectangle)t;
                    boolean bl = false;
                    if (!it.contains(plotCoord)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            DoubleRectangle doubleRectangle = geomBounds = (DoubleRectangle)v0;
            if (doubleRectangle != null) {
                DoubleRectangle it = doubleRectangle;
                boolean bl = false;
                interactionTarget = new InteractionTarget(geomBounds){
                    final /* synthetic */ DoubleRectangle $geomBounds;
                    {
                        this.$geomBounds = $geomBounds;
                    }

                    @NotNull
                    public DoubleRectangle getGeomBounds() {
                        return this.$geomBounds;
                    }

                    public void zoom(@NotNull DoubleRectangle geomBounds) {
                        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
                        System.out.println((Object)("Target zoom: " + geomBounds));
                    }
                };
            } else {
                interactionTarget = null;
            }
            return interactionTarget;
        }
    }
}

