/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J&\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/daemon/report/DebugMessagesICReporter;", "Lorg/jetbrains/kotlin/build/report/ICReporterBase;", "Lorg/jetbrains/kotlin/build/report/RemoteICReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "rootDir", "Ljava/io/File;", "isVerbose", "", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/io/File;Z)V", "flush", "", "report", "message", "Lkotlin/Function0;", "", "reportCompileIteration", "incremental", "sourceFiles", "", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "reportVerbose", "kotlin-daemon"})
public final class DebugMessagesICReporter
extends ICReporterBase
implements RemoteICReporter {
    @NotNull
    private final CompilerServicesFacadeBase servicesFacade;
    private final boolean isVerbose;

    public DebugMessagesICReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull File rootDir, boolean isVerbose) {
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        super(rootDir);
        this.servicesFacade = servicesFacade;
        this.isVerbose = isVerbose;
    }

    public void report(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.IC_MESSAGE, ReportSeverity.DEBUG, (String)message.invoke(), null, 8, null);
    }

    public void reportVerbose(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.isVerbose) {
            this.report(message);
        }
    }

    public void reportCompileIteration(boolean incremental, @NotNull Collection<? extends File> sourceFiles, @NotNull ExitCode exitCode) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
    }

    public void flush() {
    }
}

