/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantExpressionStubImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinConstantExpressionStub;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "debugName", "", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "deserialize", "dataStream", "Lcom/intellij/psi/stubs/StubInputStream;", "serialize", "", "stub", "Lcom/intellij/psi/stubs/StubOutputStream;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "Companion"})
public final class KtConstantExpressionElementType
extends KtStubElementType<KotlinConstantExpressionStub, KtConstantExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KtConstantExpressionElementType(@NonNls @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, KtConstantExpression.class, KotlinConstantExpressionStub.class);
    }

    @Override
    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (!Intrinsics.areEqual((Object)parent2.getElementType(), KtStubElementTypes.VALUE_ARGUMENT)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStub createStub(@NotNull KtConstantExpression psi, @Nullable StubElement<?> parentStub) {
        KtConstantExpressionElementType ktConstantExpressionElementType;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Object object = psi.getNode().getElementType();
        KtConstantExpressionElementType ktConstantExpressionElementType2 = ktConstantExpressionElementType = object instanceof KtConstantExpressionElementType ? (KtConstantExpressionElementType)object : null;
        if (ktConstantExpressionElementType == null) {
            throw new IllegalStateException("Stub element type is expected for constant");
        }
        KtConstantExpressionElementType elementType = ktConstantExpressionElementType;
        object = psi.getText();
        Object value2 = object == null ? "" : object;
        ConstantValueKind constantValueKind = KtConstantExpressionElementType.Companion.constantElementTypeToKind(elementType);
        object = StringRef.fromString((String)value2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromString(value)");
        return new KotlinConstantExpressionStubImpl(parentStub, elementType, constantValueKind, (StringRef)object);
    }

    @Override
    public void serialize(@NotNull KotlinConstantExpressionStub stub2, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeInt(stub2.kind().ordinal());
        dataStream.writeName(stub2.value());
    }

    @Override
    @NotNull
    public KotlinConstantExpressionStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        int kindOrdinal = dataStream.readInt();
        StringRef stringRef = dataStream.readName();
        StringRef value2 = stringRef == null ? StringRef.fromString("") : stringRef;
        ConstantValueKind valueKind = ConstantValueKind.values()[kindOrdinal];
        KtConstantExpressionElementType ktConstantExpressionElementType = Companion.kindToConstantElementType(valueKind);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
        return new KotlinConstantExpressionStubImpl(parentStub, ktConstantExpressionElementType, valueKind, value2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType$Companion;", "", "()V", "constantElementTypeToKind", "Lorg/jetbrains/kotlin/psi/stubs/ConstantValueKind;", "elementType", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "kindToConstantElementType", "kind", "psi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtConstantExpressionElementType kindToConstantElementType(@NotNull ConstantValueKind kind) {
            KtConstantExpressionElementType ktConstantExpressionElementType;
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            ConstantValueKind constantValueKind = kind;
            int n = WhenMappings.$EnumSwitchMapping$0[constantValueKind.ordinal()];
            switch (n) {
                case 1: {
                    KtConstantExpressionElementType ktConstantExpressionElementType2 = KtStubElementTypes.NULL;
                    Intrinsics.checkNotNullExpressionValue((Object)ktConstantExpressionElementType2, (String)"NULL");
                    ktConstantExpressionElementType = ktConstantExpressionElementType2;
                    break;
                }
                case 2: {
                    KtConstantExpressionElementType ktConstantExpressionElementType3 = KtStubElementTypes.BOOLEAN_CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)ktConstantExpressionElementType3, (String)"BOOLEAN_CONSTANT");
                    ktConstantExpressionElementType = ktConstantExpressionElementType3;
                    break;
                }
                case 3: {
                    KtConstantExpressionElementType ktConstantExpressionElementType4 = KtStubElementTypes.FLOAT_CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)ktConstantExpressionElementType4, (String)"FLOAT_CONSTANT");
                    ktConstantExpressionElementType = ktConstantExpressionElementType4;
                    break;
                }
                case 4: {
                    KtConstantExpressionElementType ktConstantExpressionElementType5 = KtStubElementTypes.CHARACTER_CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)ktConstantExpressionElementType5, (String)"CHARACTER_CONSTANT");
                    ktConstantExpressionElementType = ktConstantExpressionElementType5;
                    break;
                }
                case 5: {
                    KtConstantExpressionElementType ktConstantExpressionElementType6 = KtStubElementTypes.INTEGER_CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)ktConstantExpressionElementType6, (String)"INTEGER_CONSTANT");
                    ktConstantExpressionElementType = ktConstantExpressionElementType6;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktConstantExpressionElementType;
        }

        private final ConstantValueKind constantElementTypeToKind(KtConstantExpressionElementType elementType) {
            ConstantValueKind constantValueKind;
            KtConstantExpressionElementType ktConstantExpressionElementType = elementType;
            if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.NULL)) {
                constantValueKind = ConstantValueKind.NULL;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.BOOLEAN_CONSTANT)) {
                constantValueKind = ConstantValueKind.BOOLEAN_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.INTEGER_CONSTANT)) {
                constantValueKind = ConstantValueKind.INTEGER_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.FLOAT_CONSTANT)) {
                constantValueKind = ConstantValueKind.FLOAT_CONSTANT;
            } else if (Intrinsics.areEqual((Object)ktConstantExpressionElementType, (Object)KtStubElementTypes.CHARACTER_CONSTANT)) {
                constantValueKind = ConstantValueKind.CHARACTER_CONSTANT;
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown constant node type: ", (Object)elementType));
            }
            return constantValueKind;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstantValueKind.values().length];
                nArray[ConstantValueKind.NULL.ordinal()] = 1;
                nArray[ConstantValueKind.BOOLEAN_CONSTANT.ordinal()] = 2;
                nArray[ConstantValueKind.FLOAT_CONSTANT.ordinal()] = 3;
                nArray[ConstantValueKind.CHARACTER_CONSTANT.ordinal()] = 4;
                nArray[ConstantValueKind.INTEGER_CONSTANT.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

