/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    public LiteralFunctionTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration2) {
        Object it;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration2);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration2);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(in\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"invokingContext.getFunctionObject(descriptor)");
        JsFunction lambda2 = jsFunction;
        List<ValueParameterDescriptor> list2 = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"invokingContext\n        \u2026acker(lambda, descriptor)");
        TranslationContext translationContext2 = list2;
        list2 = lambda2.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor2, (List<JsParameter>)list2);
        list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        Object $this$forEach$iv = list2;
        boolean $i$f$forEach22 = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            element$iv = object.next();
            it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            lambda2.getBody().getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        $this$forEach$iv = lambda2.getBody();
        Object $i$f$forEach22 = ((JsBlock)$this$forEach$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, (String)"lambda.body.statements");
        Collection collection = (Collection)$i$f$forEach22;
        object = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setDefaultValueForArgume\u2026criptor, functionContext)");
        CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)object));
        $this$forEach$iv = lambda2.getBody();
        $i$f$forEach22 = ((JsBlock)$this$forEach$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue($i$f$forEach22, (String)"lambda.body.statements");
        ((Collection)$i$f$forEach22).add(FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration2, functionContext));
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        lambda2.setSource(declaration2);
        lambda2.getBody().setSource(finalElement instanceof LeafPsiElement ? (LeafPsiElement)finalElement : null);
        UsageTracker usageTracker = functionContext.usageTracker();
        Intrinsics.checkNotNull((Object)usageTracker);
        $i$f$forEach22 = usageTracker;
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"functionContext.usageTracker()!!");
        Object tracker = $i$f$forEach22;
        object = invokingContext.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invokingContext.getInner\u2026ForDescriptor(descriptor)");
        Object name = object;
        if (UsageTrackerKt.hasCapturedExceptContaining((UsageTracker)tracker)) {
            element$iv = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2.source(declaration2));
            Intrinsics.checkNotNullExpressionValue(element$iv, (String)"simpleReturnFunction(inv\u2026mbda.source(declaration))");
            Object lambdaCreator = element$iv;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (((UsageTracker)tracker).getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor((UsageTracker)tracker, descriptor2));
            }
            MetadataProperties.setStaticRef((JsName)name, (JsNode)lambdaCreator);
            this.fillCoroutineMetadata((JsFunction)lambdaCreator, invokingContext, descriptor2);
            ((SourceInfoAwareJsNode)lambdaCreator).setSource(declaration2);
            return LiteralFunctionTranslatorKt.withCapturedParameters((JsFunction)lambdaCreator, functionContext, (JsName)name, invokingContext, declaration2);
        }
        if (((UsageTracker)tracker).getCapturedDescriptors().contains(descriptor2)) {
            JsName jsName = UsageTrackerKt.getNameForCapturedDescriptor((UsageTracker)tracker, descriptor2);
            Intrinsics.checkNotNull((Object)jsName);
            JsName capturedName = jsName;
            it = invokingContext.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"invokingContext.getInner\u2026ForDescriptor(descriptor)");
            Object globalName = it;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf((Pair)TuplesKt.to((Object)capturedName, (Object)JsAstUtils.pureFqn((JsName)globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, (JsName)name, lambda2, declaration2);
        this.fillCoroutineMetadata(lambda2, invokingContext, descriptor2);
        MetadataProperties.setStaticRef((JsName)name, lambda2);
        object = JsAstUtils.pureFqn((JsName)name, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pureFqn(name, null)");
        return (JsExpression)object;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)$this$fillCoroutineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($this$fillCoroutineMetadata, context2, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($this$fillCoroutineMetadata, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $this$translate, @NotNull TranslationContext context2) {
        KtDestructuringDeclaration ktDestructuringDeclaration;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($this$translate);
        KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        Object object2 = object = ktParameter == null ? null : ktParameter.getDestructuringDeclaration();
        if (object == null) {
            throw new IllegalStateException(("Destructuring declaration for descriptor " + $this$translate + " not found").toString());
        }
        KtDestructuringDeclaration destructuringDeclaration = ktDestructuringDeclaration = object;
        object = ReferenceTranslator.translateAsValueReference($this$translate, context2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"translateAsValueReference(this, context)");
        Object parameterRef = object;
        object = DestructuringDeclarationTranslator.translate(destructuringDeclaration, (JsExpression)parameterRef, context2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"translate(destructuringD\u2026n, parameterRef, context)");
        return object;
    }
}

