/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.LocalNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0096\u0001J\u0011\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0096\u0001J\u0011\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0096\u0001J\u0010\u0010)\u001a\u0004\u0018\u00010!2\u0006\u0010*\u001a\u00020+J\u0011\u0010,\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0096\u0001J\u0011\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0096\u0001J\u0011\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H\u0096\u0001J\u0010\u00103\u001a\u0004\u0018\u00010!2\u0006\u00104\u001a\u000205J\u0011\u00106\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0096\u0001J\u0011\u00109\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0096\u0001J\u000e\u0010:\u001a\u00020!2\u0006\u00107\u001a\u000208J\u0011\u0010;\u001a\u00020<2\u0006\u0010\"\u001a\u00020\u001eH\u0096\u0001J\b\u0010=\u001a\u00020\u0018H\u0002J\u001e\u0010>\u001a\u00020\u00002\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ*\u0010@\u001a\u00020\u00002\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "localNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;)V", "continuation", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getContinuation", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getLocalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "checkIfJsCode", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getAssociatedObjectKey", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForReturnableBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getNameForValueDeclaration", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isCoroutineDoResume", "newDeclaration", "func", "newFile", "file", "backend.js"})
public final class JsGenerationContext
implements IrNamer {
    @Nullable
    private final IrFile currentFile;
    @Nullable
    private final IrFunction currentFunction;
    @NotNull
    private final JsStaticContext staticContext;
    @Nullable
    private final LocalNameGenerator localNames;

    public JsGenerationContext(@Nullable IrFile currentFile, @Nullable IrFunction currentFunction, @NotNull JsStaticContext staticContext, @Nullable LocalNameGenerator localNames) {
        Intrinsics.checkNotNullParameter((Object)staticContext, (String)"staticContext");
        this.currentFile = currentFile;
        this.currentFunction = currentFunction;
        this.staticContext = staticContext;
        this.localNames = localNames;
    }

    public /* synthetic */ JsGenerationContext(IrFile irFile, IrFunction irFunction2, JsStaticContext jsStaticContext, LocalNameGenerator localNameGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            localNameGenerator = null;
        }
        this(irFile, irFunction2, jsStaticContext, localNameGenerator);
    }

    @Nullable
    public final IrFile getCurrentFile() {
        return this.currentFile;
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    @Nullable
    public final LocalNameGenerator getLocalNames() {
        return this.localNames;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.staticContext.getAssociatedObjectKey(irClass2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        return this.staticContext.getNameForConstructor(constructor2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        return this.staticContext.getNameForField(field2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        return this.staticContext.getNameForMemberField(field2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return this.staticContext.getNameForProperty(property2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.staticContext.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getRefForExternalClass(klass);
    }

    @NotNull
    public final JsGenerationContext newFile(@Nullable IrFile file2, @Nullable IrFunction func, @Nullable LocalNameGenerator localNames) {
        return new JsGenerationContext(file2, func, this.staticContext, localNames);
    }

    public static /* synthetic */ JsGenerationContext newFile$default(JsGenerationContext jsGenerationContext, IrFile irFile, IrFunction irFunction2, LocalNameGenerator localNameGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            irFile = null;
        }
        if ((n & 2) != 0) {
            irFunction2 = null;
        }
        if ((n & 4) != 0) {
            localNameGenerator = null;
        }
        return jsGenerationContext.newFile(irFile, irFunction2, localNameGenerator);
    }

    @NotNull
    public final JsGenerationContext newDeclaration(@Nullable IrFunction func, @Nullable LocalNameGenerator localNames) {
        return new JsGenerationContext(this.currentFile, func, this.staticContext, localNames);
    }

    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, IrFunction irFunction2, LocalNameGenerator localNameGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            irFunction2 = null;
        }
        if ((n & 2) != 0) {
            localNameGenerator = null;
        }
        return jsGenerationContext.newDeclaration(irFunction2, localNameGenerator);
    }

    @NotNull
    public final JsExpression getContinuation() {
        JsExpression jsExpression;
        if (this.isCoroutineDoResume()) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction2 = this.currentFunction;
            Intrinsics.checkNotNull((Object)irFunction2);
            jsExpression = AdditionalIrUtilsKt.isSuspend(irFunction2) ? new JsNameRef(Namer.INSTANCE.getCONTINUATION()) : new JsNameRef(this.getNameForValueDeclaration((IrDeclarationWithName)CollectionsKt.last(this.currentFunction.getValueParameters())));
        }
        return jsExpression;
    }

    @NotNull
    public final JsName getNameForValueDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        LocalNameGenerator localNameGenerator = this.localNames;
        Intrinsics.checkNotNull((Object)localNameGenerator);
        String string2 = localNameGenerator.getVariableNames().getNames().get(declaration2);
        if (string2 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Variable name is not found ", (Object)declaration2.getName()).toString());
        }
        String name = string2;
        return new JsName(name);
    }

    @Nullable
    public final JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        LocalNameGenerator localNameGenerator = this.localNames;
        Intrinsics.checkNotNull((Object)localNameGenerator);
        String string2 = localNameGenerator.getLocalLoopNames().getNames().get(loop2);
        if (string2 == null) {
            return null;
        }
        String name = string2;
        return new JsName(name);
    }

    @Nullable
    public final JsName getNameForReturnableBlock(@NotNull IrReturnableBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        LocalNameGenerator localNameGenerator = this.localNames;
        Intrinsics.checkNotNull((Object)localNameGenerator);
        String string2 = localNameGenerator.getLocalReturnableBlockNames().getNames().get(block);
        if (string2 == null) {
            return null;
        }
        String name = string2;
        return new JsName(name);
    }

    private final boolean isCoroutineDoResume() {
        boolean bl;
        block4: {
            IrSimpleFunction irSimpleFunction;
            IrFunction irFunction2 = this.currentFunction;
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            if (irSimpleFunction == null) {
                return false;
            }
            List overriddenSymbols2 = irSimpleFunction.getOverriddenSymbols();
            Iterable $this$any$iv = overriddenSymbols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"doResume") && Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getParent(), (Object)this.getStaticContext().getCoroutineImplDeclaration()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean checkIfJsCode(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol2, (Object)this.staticContext.getBackendContext().getIntrinsics().getJsCode());
    }
}

