/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a/\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0012\u00a2\u0006\u0002\b\u0013H\u0086\b\u00f8\u0001\u0000\u001a/\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u0016*\u0002H\u00152\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00170\u00012\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0010\u001a\n\u0010\u001c\u001a\u00020\u0002*\u00020\u001b\u001a\n\u0010\u001d\u001a\u00020\r*\u00020\u0010\u001a\u0016\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010\u001b2\b\b\u0002\u0010 \u001a\u00020\u001b\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"expressionSet", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "isClassLocal", "classNode", "Lcom/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "stubMode", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;Z)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "getAsStringWithoutBacktick", "", "getOperationSymbol", "isExpression", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "light-tree2fir"})
public final class ConverterUtilKt {
    @NotNull
    private static final List<IElementType> expressionSet;

    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        if ($this$nameAsSafeName != null) {
            Name name2 = Name.identifier(KtPsiUtil.unquoteIdentifier($this$nameAsSafeName));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(KtPsiUtil.unquoteIdentifier(this))");
            name = name2;
        } else if (((CharSequence)defaultName).length() > 0) {
            Name name3 = Name.identifier(defaultName);
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(defaultName)");
            name = name3;
        } else {
            name = SpecialNames.NO_NAME_PROVIDED;
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$getOperationSymbol, (String)"<this>");
        Object object = KotlinExpressionParsing.ALL_OPERATIONS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ALL_OPERATIONS.types");
        Object[] $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType it = (IElementType)element$iv;
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual((Object)((KtSingleValueToken)it).getValue(), (Object)$this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual((Object)$this$getOperationSymbol, (Object)"as?")) {
            object = KtTokens.AS_SAFE;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AS_SAFE");
            return (IElementType)object;
        }
        object = KtTokens.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IDENTIFIER");
        return (IElementType)object;
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsStringWithoutBacktick, (String)"<this>");
        return StringsKt.replace$default((String)$this$getAsStringWithoutBacktick.toString(), (String)"`", (String)"", (boolean)false, (int)4, null);
    }

    public static final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$isExpression, (String)"<this>");
        IElementType iElementType = $this$isExpression.getTokenType();
        return ((iElementType instanceof KtNodeType ? true : iElementType instanceof KtConstantExpressionElementType) ? true : iElementType instanceof KtStringTemplateExpressionElementType) ? true : expressionSet.contains(iElementType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container, boolean stubMode) {
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        if (!stubMode || $this$extractArgumentsFrom instanceof FirAnnotationCallBuilder) {
            void $this$extractArgumentsFrom_u24lambda_u2d1;
            FirArgumentListBuilder firArgumentListBuilder;
            boolean $i$f$buildArgumentList = false;
            FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
            T t = $this$extractArgumentsFrom;
            boolean bl = false;
            void var7_8 = $this$extractArgumentsFrom_u24lambda_u2d1;
            Collection collection = var7_8.getArguments();
            CollectionsKt.addAll((Collection)collection, (Iterable)container);
            Unit unit2 = Unit.INSTANCE;
            t.setArgumentList(firArgumentListBuilder.build());
        }
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(getParent, (String)"getParent");
        boolean $i$f$isClassLocal = false;
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType parentTokenType;
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode parent2 = (LighterASTNode)getParent.invoke((Object)currentNode);
            LighterASTNode lighterASTNode2 = parent2;
            IElementType iElementType = parentTokenType = lighterASTNode2 == null ? null : lighterASTNode2.getTokenType();
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.PROPERTY) || Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode3;
                LighterASTNode lighterASTNode4 = parent2;
                LighterASTNode grandParent = lighterASTNode4 == null ? null : (LighterASTNode)getParent.invoke((Object)lighterASTNode4);
                if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.KT_FILE)) {
                    return true;
                }
                if (!(!Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)((lighterASTNode4 = grandParent) == null ? null : lighterASTNode4.getTokenType()), (Object)KtNodeTypes.OBJECT_DECLARATION) && Intrinsics.areEqual((lighterASTNode4 = grandParent) == null ? null : ((lighterASTNode3 = (LighterASTNode)getParent.invoke((Object)lighterASTNode4)) == null ? null : lighterASTNode3.getTokenType()), (Object)KtNodeTypes.OBJECT_LITERAL))) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.BLOCK) && Intrinsics.areEqual((Object)((lighterASTNode4 = grandParent) == null ? null : lighterASTNode4.getTokenType()), (Object)KtNodeTypes.SCRIPT)) {
                    return true;
                }
            }
            if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.ENUM_ENTRY)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirBlock generateDestructuringBlock(@NotNull FirModuleData moduleData, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable container, boolean tmpVariable) {
        Object object;
        FirBlockBuilder firBlockBuilder;
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        boolean $i$f$buildBlock = false;
        FirBlockBuilder $this$generateDestructuringBlock_u24lambda_u2d4 = firBlockBuilder = new FirBlockBuilder();
        boolean bl = false;
        if (tmpVariable) {
            FirBlockBuilder firBlockBuilder2 = $this$generateDestructuringBlock_u24lambda_u2d4;
            object = firBlockBuilder2.getStatements();
            object.add(container);
        }
        boolean isVar = multiDeclaration.isVar();
        object = multiDeclaration.getEntries().iterator();
        int n = 0;
        while (object.hasNext()) {
            void $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2;
            FirComponentCallBuilder firComponentCallBuilder;
            FirPropertyBuilder firPropertyBuilder;
            int index2 = n++;
            FirVariable entry = (FirVariable)object.next();
            if (entry == null) continue;
            FirBlockBuilder firBlockBuilder3 = $this$generateDestructuringBlock_u24lambda_u2d4;
            Collection collection = firBlockBuilder3.getStatements();
            boolean $i$f$buildProperty = false;
            FirPropertyBuilder $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3 = firPropertyBuilder = new FirPropertyBuilder();
            boolean bl2 = false;
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setModuleData(moduleData);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setReturnTypeRef(entry.getReturnTypeRef());
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setName(entry.getName());
            boolean $i$f$buildComponentCall = false;
            FirComponentCallBuilder firComponentCallBuilder2 = firComponentCallBuilder = new FirComponentCallBuilder();
            FirPropertyBuilder firPropertyBuilder2 = $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3;
            boolean bl3 = false;
            FirSourceElement firSourceElement = entry.getSource();
            FirSourceElement componentCallSource = firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setSource(componentCallSource);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(componentCallSource, container));
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setComponentIndex(index2 + 1);
            Unit unit2 = Unit.INSTANCE;
            firPropertyBuilder2.setInitializer(firComponentCallBuilder.build());
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setVar(isVar);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setSymbol(new FirPropertySymbol(entry.getName()));
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setSource(entry.getSource());
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setLocal(true);
            $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
            FirPropertyBuilder firPropertyBuilder3 = $this$generateDestructuringBlock_u24lambda_u2d4_u24lambda_u2d3;
            CollectionsKt.addAll((Collection)firPropertyBuilder3.getAnnotations(), (Iterable)entry.getAnnotations());
            FirProperty firProperty = firPropertyBuilder.build();
            collection.add(firProperty);
        }
        return firBlockBuilder.build();
    }

    static {
        Object[] objectArray = new IElementType[]{KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN};
        expressionSet = CollectionsKt.listOf((Object[])objectArray);
    }
}

