/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getStaticFunctionWithReceivers", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend.jvm.lower"})
final class StaticDefaultFunctionLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public StaticDefaultFunctionLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) && declaration2.getDispatchReceiverParameter() != null) {
            void it;
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2 = this.getStaticFunctionWithReceivers(declaration2);
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            it.setBody(IrInlineUtilsKt.moveBodyTo(declaration2, (IrFunction)it));
            Unit unit2 = Unit.INSTANCE;
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irSimpleFunction = irSimpleFunction2;
        } else {
            irSimpleFunction = declaration2;
        }
        return super.visitFunction(irSimpleFunction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (((Map)this.context.getStaticDefaultStubs()).containsKey(expression2.getReturnTargetSymbol())) {
            void $this$visitReturn_u24lambda_u2d1;
            IrReturn irReturn2 = expression2;
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            Object v = ((Map)this.getContext().getStaticDefaultStubs()).get(expression2.getReturnTargetSymbol());
            Intrinsics.checkNotNull(v);
            IrSimpleFunction irFunction2 = (IrSimpleFunction)v;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$visitReturn_u24lambda_u2d1.getStartOffset(), $this$visitReturn_u24lambda_u2d1.getEndOffset(), $this$visitReturn_u24lambda_u2d1.getType(), irFunction2.getSymbol(), $this$visitReturn_u24lambda_u2d1.getValue());
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irReturn = irReturnImpl;
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (callee.getOrigin() != IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE || expression2.getDispatchReceiver() == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction newCallee = this.getStaticFunctionWithReceivers(callee);
        IrCall newCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, newCallee, true, false, null, null, 56, null);
        return super.visitCall(newCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getStaticFunctionWithReceivers(IrSimpleFunction function2) {
        Object object;
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.context.getStaticDefaultStubs();
        IrSimpleFunctionSymbol key$iv = function2.getSymbol();
        boolean $i$f$getOrPut = false;
        Object v = $this$getOrPut$iv.get(key$iv);
        if (v == null) {
            IrSimpleFunction irSimpleFunction;
            boolean bl = false;
            IrSimpleFunction default$iv = irSimpleFunction = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createStaticFunctionWithReceivers$default(this.getContext().getIrFactory(), function2.getParent(), function2.getName(), function2, null, null, null, null, false, false, null, 1016, null);
            boolean bl2 = false;
            IrSimpleFunction irSimpleFunction2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            object = irSimpleFunction2 == null ? default$iv : irSimpleFunction2;
        } else {
            object = v;
        }
        Object v2 = object;
        Intrinsics.checkNotNullExpressionValue(v2, (String)"context.staticDefaultStu\u2026name, function)\n        }");
        return (IrSimpleFunction)v2;
    }
}

