/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtensionComponentAdapter
implements LoadingOrder.Orderable {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    @NotNull
    private final PluginDescriptor pluginDescriptor;
    @NotNull
    Object implementationClassOrName;
    private final String orderId;
    private final LoadingOrder order;

    ExtensionComponentAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order2) {
        if (implementationClassName == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(1);
        }
        if (order2 == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(2);
        }
        this.implementationClassOrName = implementationClassName;
        this.pluginDescriptor = pluginDescriptor;
        this.orderId = orderId;
        this.order = order2;
    }

    abstract boolean isInstanceCreated();

    @NotNull
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Class<T> aClass;
        if (componentManager == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(3);
        }
        try {
            aClass = this.getImplementationClass();
        }
        catch (ClassNotFoundException e) {
            throw componentManager.createError(e, this.pluginDescriptor.getPluginId());
        }
        T instance = this.instantiateClass(aClass, componentManager);
        if (instance instanceof PluginAware) {
            ((PluginAware)instance).setPluginDescriptor(this.pluginDescriptor);
        }
        T t = instance;
        if (t == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(4);
        }
        return t;
    }

    @NotNull
    protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
        if (aClass == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(5);
        }
        if (componentManager == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(6);
        }
        T t = componentManager.instantiateClass(aClass, this.pluginDescriptor.getPluginId());
        if (t == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Override
    public final LoadingOrder getOrder() {
        return this.order;
    }

    @Override
    public final String getOrderId() {
        return this.orderId;
    }

    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(8);
        }
        return pluginDescriptor;
    }

    @NotNull
    public final <T> Class<T> getImplementationClass() throws ClassNotFoundException {
        Class<?> implementationClassOrName = this.implementationClassOrName;
        if (implementationClassOrName instanceof String) {
            ClassLoader classLoader = this.pluginDescriptor.getPluginClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.implementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
        }
        Class clazz = implementationClassOrName;
        if (clazz == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(9);
        }
        return clazz;
    }

    @NotNull
    public final String getAssignableToClassName() {
        Object implementationClassOrName = this.implementationClassOrName;
        if (implementationClassOrName instanceof String) {
            String string2 = (String)implementationClassOrName;
            if (string2 == null) {
                ExtensionComponentAdapter.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String string3 = ((Class)implementationClassOrName).getName();
        if (string3 == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(11);
        }
        return string3;
    }

    public String toString() {
        return "ExtensionComponentAdapter(impl=" + this.getAssignableToClassName() + ", plugin=" + this.pluginDescriptor + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignableToClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

