/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageExtension;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.TokenSeparatorGenerator;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;

public final class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("org.jetbrains.kotlin.com.intellij.lang.tokenSeparatorGenerator", new TokenSeparatorGenerator(){

            @Override
            public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
                ParserDefinition parserDefinition;
                Language l = PsiUtilCore.getNotAnyLanguage(left);
                Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
                if (rightLang.isKindOf(l)) {
                    l = rightLang;
                }
                if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)) != null) {
                    LeafElement generatedWhitespace;
                    PsiManager manager = right.getTreeParent().getPsi().getManager();
                    switch (parserDefinition.spaceExistenceTypeBetweenTokens(left, right)) {
                        case MUST: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager);
                            break;
                        }
                        case MUST_LINE_BREAK: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager);
                            break;
                        }
                        default: {
                            generatedWhitespace = null;
                        }
                    }
                    return generatedWhitespace;
                }
                return null;
            }
        });
    }
}

