/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.blockmap;

import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.BlockMapService;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import retrofit2.Response;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0002J\t\u0010\u001c\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\tH\u0002J,\u0010&\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0002R*\u0010\u000b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/blockmap/PluginChunkDataSource;", "", "", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "pluginFileService", "Lorg/jetbrains/intellij/pluginRepository/internal/api/BlockMapService;", "fileName", "", "(Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lorg/jetbrains/intellij/pluginRepository/internal/api/BlockMapService;Ljava/lang/String;)V", "chunkSequences", "Ljava/util/ArrayList;", "", "Lcom/jetbrains/plugin/blockmap/core/Chunk;", "Lkotlin/collections/ArrayList;", "chunks", "", "curChunkData", "oldSet", "", "pointer", "", "pos", "getRange", "range", "hasNext", "", "next", "nextChunkSequence", "bytes", "nextLine", "input", "Ljava/io/BufferedInputStream;", "nextRange", "parseHttpMultirangeHeaders", "", "boundary", "parseHttpRangeBody", "sequence", "result", "rest"})
public final class PluginChunkDataSource
implements Iterator<byte[]>,
KMappedMarker {
    @NotNull
    private final BlockMapService pluginFileService;
    @NotNull
    private final String fileName;
    @NotNull
    private final Set<Chunk> oldSet;
    @NotNull
    private final List<Chunk> chunks;
    private int pos;
    @NotNull
    private ArrayList<List<Chunk>> chunkSequences;
    @NotNull
    private List<byte[]> curChunkData;
    private int pointer;

    /*
     * WARNING - void declaration
     */
    public PluginChunkDataSource(@NotNull BlockMap oldBlockMap, @NotNull BlockMap newBlockMap, @NotNull BlockMapService pluginFileService, @NotNull String fileName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)oldBlockMap, (String)"oldBlockMap");
        Intrinsics.checkNotNullParameter((Object)newBlockMap, (String)"newBlockMap");
        Intrinsics.checkNotNullParameter((Object)pluginFileService, (String)"pluginFileService");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.pluginFileService = pluginFileService;
        this.fileName = fileName;
        this.oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable iterable = newBlockMap.getChunks();
        PluginChunkDataSource pluginChunkDataSource = this;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!this.oldSet.contains(chunk))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        pluginChunkDataSource.chunks = (List)destination$iv$iv;
        this.chunkSequences = new ArrayList();
        this.curChunkData = this.getRange(this.nextRange());
    }

    @Override
    public boolean hasNext() {
        return this.curChunkData.size() != 0;
    }

    @Override
    @NotNull
    public byte[] next() {
        byte[] byArray;
        if (this.curChunkData.size() != 0) {
            if (this.pointer < this.curChunkData.size()) {
                int n = this.pointer;
                this.pointer = n + 1;
                byArray = this.curChunkData.get(n);
            } else {
                this.curChunkData = this.getRange(this.nextRange());
                this.pointer = 0;
                byArray = this.next();
            }
        } else {
            throw new NoSuchElementException();
        }
        return byArray;
    }

    private final String nextRange() {
        List<Chunk> chunkSequence;
        StringBuilder range = new StringBuilder("bytes=");
        this.chunkSequences.clear();
        for (int bytes = 0; this.pos < this.chunks.size() && range.length() < 19000 && bytes < 10000000; bytes += ((Chunk)CollectionsKt.last(chunkSequence)).getOffset() + ((Chunk)CollectionsKt.last(chunkSequence)).getLength() - chunkSequence.get(0).getOffset()) {
            chunkSequence = this.nextChunkSequence(bytes);
            this.chunkSequences.add(chunkSequence);
            range.append(chunkSequence.get(0).getOffset() + "-" + (((Chunk)CollectionsKt.last(chunkSequence)).getOffset() + ((Chunk)CollectionsKt.last(chunkSequence)).getLength() - 1) + ",");
        }
        return ((Object)StringsKt.removeSuffix((CharSequence)range, (CharSequence)",")).toString();
    }

    private final List<Chunk> nextChunkSequence(int bytes) {
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        result.add(this.chunks.get(this.pos));
        int n = this.pos;
        this.pos = n + 1;
        int sum = ((Chunk)result.get(0)).getLength();
        while (this.pos < this.chunks.size() - 1 && this.chunks.get(this.pos).getOffset() == this.chunks.get(this.pos - 1).getOffset() + this.chunks.get(this.pos - 1).getLength() && sum + bytes < 10000000) {
            result.add(this.chunks.get(this.pos));
            sum += this.chunks.get(this.pos).getLength();
            int n2 = this.pos;
            this.pos = n2 + 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<byte[]> getRange(String range) {
        ArrayList result = new ArrayList();
        Response<ResponseBody> executed = RequestHelperKt.executeExceptionally(this.pluginFileService.getPluginFile(this.fileName, range));
        String string = executed.headers().get("Content-Type");
        if (string == null) {
            throw new IOException(Messages.INSTANCE.getMessage("http.response.content.type.null", new Object[0]));
        }
        String contentType = string;
        String boundary = StringsKt.removePrefix((String)contentType, (CharSequence)"multipart/byteranges; boundary=");
        ResponseBody responseBody = (ResponseBody)executed.body();
        if (responseBody == null) {
            throw new IOException(Messages.INSTANCE.getMessage("http.response.body.null", new Object[0]));
        }
        ResponseBody response = responseBody;
        Closeable closeable = response.byteStream();
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            if (this.chunkSequences.size() > 1) {
                for (List<Chunk> sequence : this.chunkSequences) {
                    this.parseHttpMultirangeHeaders(input, boundary);
                    Intrinsics.checkNotNullExpressionValue(sequence, (String)"sequence");
                    this.parseHttpRangeBody(input, sequence, result);
                }
            } else {
                List<Chunk> list = this.chunkSequences.get(0);
                Intrinsics.checkNotNullExpressionValue(list, (String)"chunkSequences[0]");
                this.parseHttpRangeBody(input, list, result);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    private final void parseHttpMultirangeHeaders(BufferedInputStream input, String boundary) {
        String openingEmptyLine = this.nextLine(input);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)openingEmptyLine)).toString()).length() > 0) {
            throw new IOException(Messages.INSTANCE.getMessage("http.multirange.response.doesnt.include.line.separator", new Object[0]));
        }
        String boundaryLine = this.nextLine(input);
        if (!StringsKt.contains$default((CharSequence)boundaryLine, (CharSequence)boundary, (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{boundaryLine, boundary};
            throw new IOException(Messages.INSTANCE.getMessage("http.multirange.response.doesnt.contain.boundary", objectArray));
        }
        String contentTypeLine = this.nextLine(input);
        if (!StringsKt.startsWith$default((String)contentTypeLine, (String)"Content-Type", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{contentTypeLine, "Content-Type"};
            throw new IOException(Messages.INSTANCE.getMessage("http.multirange.response.includes.incorrect.header", objectArray));
        }
        String contentRangeLine = this.nextLine(input);
        if (!StringsKt.startsWith$default((String)contentRangeLine, (String)"Content-Range", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{contentRangeLine, "Content-Range"};
            throw new IOException(Messages.INSTANCE.getMessage("http.multirange.response.includes.incorrect.header", objectArray));
        }
        String closingEmptyLine = this.nextLine(input);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)closingEmptyLine)).toString()).length() > 0) {
            throw new IOException(Messages.INSTANCE.getMessage("http.multirange.response.doesnt.include.line.separator", new Object[0]));
        }
    }

    private final void parseHttpRangeBody(BufferedInputStream input, List<Chunk> sequence, List<byte[]> result) {
        for (Chunk chunk : sequence) {
            byte[] data = new byte[chunk.getLength()];
            int n = chunk.getLength();
            for (int i = 0; i < n; ++i) {
                data[i] = (byte)input.read();
            }
            result.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String nextLine(BufferedInputStream input) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int n;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            do {
                n = input.read();
                baos.write(n);
                if (baos.size() < 1024) continue;
                Object[] objectArray = new Object[1];
                byte[] byArray = baos.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
                byte[] byArray2 = byArray;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                Charset charset2 = charset;
                objectArray[0] = new String(byArray2, charset2);
                throw new IOException(Messages.INSTANCE.getMessage("wrong.http.range.response", objectArray));
            } while ((char)n != '\n');
            byte[] byArray = baos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
            byte[] byArray3 = byArray;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
            Charset charset3 = charset;
            String string = new String(byArray3, charset3);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

