/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.integration.jms;

import java.util.Map;
import javax.jms.Message;
import javax.jms.QueueSender;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;
import org.jeasy.batch.extensions.integration.DefaultPredicate;
import org.jeasy.batch.extensions.integration.Predicate;

public class ContentBasedJmsQueueRecordWriter<P>
implements RecordWriter<P> {
    private Map<Predicate<P>, QueueSender> queueMap;

    ContentBasedJmsQueueRecordWriter(Map<Predicate<P>, QueueSender> queueMap) {
        this.queueMap = queueMap;
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        DefaultPredicate defaultPredicate = new DefaultPredicate();
        QueueSender defaultQueue = this.queueMap.get(defaultPredicate);
        for (Record record : batch) {
            boolean matched = false;
            Message payload = (Message)record.getPayload();
            for (Map.Entry<Predicate<P>, QueueSender> entry : this.queueMap.entrySet()) {
                Predicate<P> predicate = entry.getKey();
                if (predicate instanceof DefaultPredicate || !predicate.matches(record)) continue;
                this.queueMap.get(predicate).send(payload);
                matched = true;
                break;
            }
            if (matched || defaultQueue == null) continue;
            defaultQueue.send(payload);
        }
    }

    Map<Predicate<P>, QueueSender> getQueueMap() {
        return this.queueMap;
    }
}

