/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.integration;

import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;

public class RandomBlockingQueueRecordWriter<P>
implements RecordWriter<P> {
    private int queuesNumber;
    private List<BlockingQueue<Record<P>>> queues;
    private Random random;

    public RandomBlockingQueueRecordWriter(List<BlockingQueue<Record<P>>> queues) {
        this.queues = queues;
        this.queuesNumber = queues.size();
        this.random = new Random();
    }

    public void writeRecords(Batch<P> batch) throws Exception {
        for (Record record : batch) {
            BlockingQueue<Record<P>> queue = this.queues.get(this.random.nextInt(this.queuesNumber));
            queue.put(record);
        }
    }
}

