/*
 * Licensed to jclouds, Inc. (jclouds) under one or more
 * contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  jclouds licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jclouds.joyent.cloudapi.v6_5.predicates;

import static com.google.common.base.Preconditions.checkNotNull;

import org.jclouds.joyent.cloudapi.v6_5.domain.Key;

import com.google.common.base.Predicate;

/**
 * Predicates handy when working with Keys
 * 
 * @author Adrian Cole
 */

public class KeyPredicates {


   /**
    * matches name of the given key pair
    * 
    * @param name
    * @return predicate that matches name
    */
   public static Predicate<Key> nameMatches(final Predicate<String> name) {
      checkNotNull(name, "name must be defined");

      return new Predicate<Key>() {
         @Override
         public boolean apply(Key ext) {
            return name.apply(ext.getName());
         }

         @Override
         public String toString() {
            return "nameMatches(" + name + ")";
         }
      };
   }
  
}
