/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.DiskSection;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.internal.BaseVirtualSystem;

public class BaseEnvelope<V extends BaseVirtualSystem<V>, E extends BaseEnvelope<V, E>> {
    private final Set<DiskSection> diskSections;
    private final Set<NetworkSection> networkSections;
    private final Multimap<String, Section> additionalSections;
    private final V virtualSystem;

    public static <V extends BaseVirtualSystem<V>, E extends BaseEnvelope<V, E>> Builder<V, E> builder() {
        return new Builder();
    }

    public Builder<V, E> toBuilder() {
        return new Builder().fromEnvelope(this);
    }

    public BaseEnvelope(Iterable<? extends DiskSection> diskSections, Iterable<? extends NetworkSection> networkSections, Multimap<String, Section> additionalSections, V virtualSystem) {
        this.diskSections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(diskSections, (Object)"diskSections")));
        this.networkSections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(networkSections, (Object)"networkSections")));
        this.additionalSections = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(additionalSections, (Object)"additionalSections")));
        this.virtualSystem = (BaseVirtualSystem)Preconditions.checkNotNull(virtualSystem, (Object)"virtualSystem");
    }

    public V getVirtualSystem() {
        return this.virtualSystem;
    }

    public Set<? extends DiskSection> getDiskSections() {
        return this.diskSections;
    }

    public Multimap<String, Section> getAdditionalSections() {
        return this.additionalSections;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalSections == null ? 0 : this.additionalSections.hashCode());
        result = 31 * result + (this.diskSections == null ? 0 : ((Object)this.diskSections).hashCode());
        result = 31 * result + (this.networkSections == null ? 0 : ((Object)this.networkSections).hashCode());
        result = 31 * result + (this.virtualSystem == null ? 0 : ((BaseVirtualSystem)this.virtualSystem).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEnvelope other = (BaseEnvelope)obj;
        if (this.additionalSections == null ? other.additionalSections != null : !this.additionalSections.equals(other.additionalSections)) {
            return false;
        }
        if (this.diskSections == null ? other.diskSections != null : !((Object)this.diskSections).equals(other.diskSections)) {
            return false;
        }
        if (this.networkSections == null ? other.networkSections != null : !((Object)this.networkSections).equals(other.networkSections)) {
            return false;
        }
        return !(this.virtualSystem == null ? other.virtualSystem != null : !((BaseVirtualSystem)this.virtualSystem).equals(other.virtualSystem));
    }

    public String toString() {
        return String.format("[diskSections=%s, networkSections=%s, additionalSections=%s, virtualSystem=%s]", this.diskSections, this.networkSections, this.additionalSections, this.virtualSystem);
    }

    public Set<NetworkSection> getNetworkSections() {
        return this.networkSections;
    }

    public static class Builder<V extends BaseVirtualSystem<V>, E extends BaseEnvelope<V, E>> {
        protected Set<DiskSection> diskSections = Sets.newLinkedHashSet();
        protected Set<NetworkSection> networkSections = Sets.newLinkedHashSet();
        protected Multimap<String, Section> additionalSections = LinkedHashMultimap.create();
        protected V virtualSystem;

        public Builder<V, E> diskSection(DiskSection diskSection) {
            this.diskSections.add((DiskSection)Preconditions.checkNotNull((Object)diskSection, (Object)"diskSection"));
            return this;
        }

        public Builder<V, E> diskSections(Iterable<? extends DiskSection> diskSections) {
            this.diskSections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(diskSections, (Object)"diskSections")));
            return this;
        }

        public Builder<V, E> networkSection(NetworkSection networkSection) {
            this.networkSections.add((NetworkSection)Preconditions.checkNotNull((Object)networkSection, (Object)"networkSection"));
            return this;
        }

        public Builder<V, E> networkSections(Iterable<? extends NetworkSection> networkSections) {
            this.networkSections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(networkSections, (Object)"networkSections")));
            return this;
        }

        public Builder<V, E> additionalSection(String name, Section additionalSection) {
            this.additionalSections.put(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)additionalSection, (Object)"additionalSection"));
            return this;
        }

        public Builder<V, E> additionalSections(Multimap<String, Section> additionalSections) {
            this.additionalSections = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(additionalSections, (Object)"additionalSections")));
            return this;
        }

        public Builder<V, E> virtualSystem(V virtualSystem) {
            this.virtualSystem = virtualSystem;
            return this;
        }

        public E build() {
            return (E)new BaseEnvelope(this.diskSections, this.networkSections, this.additionalSections, this.virtualSystem);
        }

        public Builder<V, E> fromEnvelope(BaseEnvelope<V, E> in) {
            return this.virtualSystem(in.getVirtualSystem()).diskSections(in.getDiskSections()).networkSections(this.networkSections).additionalSections(in.getAdditionalSections());
        }
    }
}

