/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class ImageImpl
extends ComputeMetadataImpl
implements Image {
    private final OperatingSystem operatingSystem;
    private final Image.Status status;
    private final String backendStatus;
    private final String version;
    private final String description;
    private final LoginCredentials defaultCredentials;

    public ImageImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, OperatingSystem operatingSystem, Image.Status status, @Nullable String backendStatus, String description, @Nullable String version, @Nullable LoginCredentials defaultCredentials) {
        super(ComputeType.IMAGE, providerId, name, id, location, uri, userMetadata, tags);
        this.operatingSystem = (OperatingSystem)Preconditions.checkNotNull((Object)operatingSystem, (Object)"operatingSystem");
        this.status = (Image.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.backendStatus = backendStatus;
        this.version = version;
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.defaultCredentials = defaultCredentials;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Image.Status getStatus() {
        return this.status;
    }

    @Override
    public String getBackendStatus() {
        return this.backendStatus;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LoginCredentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    @Override
    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper helper = this.computeToStringPrefix();
        helper.add("os", (Object)this.getOperatingSystem()).add("description", (Object)this.getDescription()).add("version", (Object)this.getVersion()).add("status", (Object)ComputeServiceUtils.formatStatus(this)).add("loginUser", this.defaultCredentials != null ? this.defaultCredentials.identity : null);
        return this.addComputeToStringSuffix(helper);
    }
}

