/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.handlers;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.domain.AuthenticationResponse;

@Singleton
public class RetryOnRenew
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final LoadingCache<Credentials, AuthenticationResponse> authenticationResponseCache;

    @Inject
    protected RetryOnRenew(LoadingCache<Credentials, AuthenticationResponse> authenticationResponseCache) {
        this.authenticationResponseCache = authenticationResponseCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            switch (response.getStatusCode()) {
                case 401: {
                    Multimap headers = command.getCurrentRequest().getHeaders();
                    if (headers != null && headers.containsKey((Object)"X-Auth-User") && headers.containsKey((Object)"X-Auth-Key") && !headers.containsKey((Object)"X-Auth-Token")) {
                        retry = false;
                        break;
                    }
                    byte[] content = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                    if (content != null && new String(content).contains("lease renew")) {
                        this.logger.debug("invalidating authentication token", new Object[0]);
                        this.authenticationResponseCache.invalidateAll();
                        retry = true;
                        break;
                    }
                    retry = false;
                }
            }
            boolean bl = retry;
            return bl;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }
}

