/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spi.mgmt;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jbpm.integration.spi.mgmt.AbstractServerConfigMBean;
import org.jbpm.integration.util.ObjectNameFactory;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean {
    private static final Logger log = Logger.getLogger(AbstractServerConfig.class);
    private MBeanServer mbeanServer;
    private static final String UNDEFINED_HOSTNAME = "undefined.host";
    private String webServiceHost = "undefined.host";
    private int webServicePort;
    private int webServiceSecurePort;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public abstract String getImplementationTitle();

    public abstract String getImplementationVersion();

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            log.debug((Object)"Using undefined host: undefined.host");
            host = UNDEFINED_HOSTNAME;
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            log.debug((Object)("Using local host: " + localHost.getHostName()));
            host = localHost.getHostName();
        }
        this.webServiceHost = host;
    }

    public void setWebServicePort(int port) {
        this.webServicePort = port;
    }

    public void setWebServiceSecurePort(int port) {
        this.webServiceSecurePort = port;
    }

    public int getWebServicePort() {
        int localPort;
        if (this.webServicePort <= 0) {
            this.webServicePort = this.getConnectorPort("HTTP/1.1", false);
        }
        if ((localPort = this.webServicePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServicePort', using default '8080'");
            localPort = 8080;
        }
        return localPort;
    }

    public int getWebServiceSecurePort() {
        int localPort;
        if (this.webServiceSecurePort <= 0) {
            this.webServiceSecurePort = this.getConnectorPort("HTTP/1.1", true);
        }
        if ((localPort = this.webServiceSecurePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServiceSecurePort', using default '8443'");
            localPort = 8443;
        }
        return localPort;
    }

    private int getConnectorPort(String protocol, boolean secure) {
        int port = -1;
        try {
            ObjectName connectors = new ObjectName("jboss.web:type=Connector,*");
            Set<ObjectName> connectorNames = this.getMbeanServer().queryNames(connectors, null);
            Iterator<ObjectName> i$ = connectorNames.iterator();
            while (i$.hasNext()) {
                ObjectName current;
                ObjectName currentName = current = i$.next();
                try {
                    int connectorPort = (Integer)this.getMbeanServer().getAttribute(currentName, "port");
                    boolean connectorSecure = (Boolean)this.getMbeanServer().getAttribute(currentName, "secure");
                    String connectorProtocol = (String)this.getMbeanServer().getAttribute(currentName, "protocol");
                    if (!protocol.equals(connectorProtocol) || secure != connectorSecure) continue;
                    if (port > -1) {
                        log.warn((Object)("Found multiple connectors for protocol='" + protocol + "' and secure='" + secure + "', using first port found '" + port + "'"));
                        continue;
                    }
                    port = connectorPort;
                }
                catch (AttributeNotFoundException ignored) {}
            }
            return port;
        }
        catch (JMException e) {
            return -1;
        }
    }

    public File getServerTempDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "ServerTempDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public File getHomeDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "HomeDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public File getServerDataDir() {
        try {
            ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File dir = (File)this.getMbeanServer().getAttribute(oname, "ServerDataDir");
            return dir;
        }
        catch (JMException e) {
            return null;
        }
    }

    public void create() throws Exception {
        this.getMbeanServer().registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
    }

    public void destroy() throws Exception {
        this.getMbeanServer().unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
    }
}

