/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spi;

import javax.naming.InitialContext;
import org.jbpm.api.Configuration;
import org.jbpm.api.ProcessEngine;
import org.jbpm.integration.spi.ProcessEngineReference;
import org.jbpm.integration.spi.mgmt.ServerConfig;
import org.jbpm.internal.log.Log;

public class JBPMService {
    private static final Log log = Log.getLog((String)JBPMService.class.getName());
    private static final String DEFAULT_JNDI_NAME = "java:/ProcessEngine";
    private ProcessEngine processEngine;
    private ServerConfig serverConfig;
    private String jndiName = "java:/ProcessEngine";

    public void start() {
        this.processEngine = new Configuration().buildProcessEngine();
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(DEFAULT_JNDI_NAME, (Object)new ProcessEngineReference("default", this.processEngine));
            log.info(this.serverConfig.getImplementationTitle());
            log.info(this.serverConfig.getImplementationVersion());
            log.info("ProcessEngine bound to: " + this.jndiName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JBPMService", e);
        }
    }

    public void stop() {
        this.processEngine = null;
        log.info("JBPMService stopped");
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

