/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spi;

import java.io.File;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.naming.InitialContext;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jbpm.api.RepositoryService;
import org.jbpm.integration.spi.DeploymentRef;
import org.jbpm.integration.spi.JBPMDeploymentMetaData;
import org.jbpm.integration.spi.JBPMService;
import org.jbpm.integration.spi.JBPMServiceLocator;
import org.jbpm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAdaptor {
    private static final Log log = Log.getLog((String)DeploymentAdaptor.class.getName());

    public DeploymentRef deploy(JBPMDeploymentMetaData deploymentMetData) {
        JBPMService jbpmService = JBPMServiceLocator.locateService();
        UserTransaction tx = null;
        try {
            InitialContext ctx = new InitialContext();
            tx = (UserTransaction)ctx.lookup("UserTransaction");
            tx.begin();
            RepositoryService repositoryService = jbpmService.getProcessEngine().getRepositoryService();
            String deploymentName = deploymentMetData.getWatch().getPath();
            File deploymentFile = new File(deploymentName);
            String deploymentId = repositoryService.createDeployment().addResourcesFromZipInputStream(new ZipInputStream(deploymentMetData.getWatch().openStream())).setTimestamp(deploymentFile.lastModified()).setName(deploymentName).deploy();
            DeploymentRef deploymentRef = new DeploymentRef(deploymentId, deploymentName);
            tx.commit();
            return deploymentRef;
        }
        catch (Throwable e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (SystemException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Failed to deploy process", e);
        }
    }

    public void undeploy(List<DeploymentRef> deploymentRefs) {
        UserTransaction tx = null;
        try {
            JBPMService jbpmService = JBPMServiceLocator.locateService();
            RepositoryService repositoryService = jbpmService.getProcessEngine().getRepositoryService();
            InitialContext ctx = new InitialContext();
            tx = (UserTransaction)ctx.lookup("UserTransaction");
            tx.begin();
            for (DeploymentRef deploymentRef : deploymentRefs) {
                File deploymentArtifact = new File(deploymentRef.getLocation());
                if (!deploymentArtifact.exists()) {
                    log.info("The deployment artifact for process '" + deploymentRef + " has been deleted." + " The process definition will be removed.");
                    repositoryService.suspendDeployment(deploymentRef.getDeploymentId());
                    continue;
                }
                log.info("The deployment artifact for process '" + deploymentRef + "' retains. " + "Keep process definition.");
            }
            tx.commit();
        }
        catch (Throwable e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (SystemException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Failed to undeploy process", e);
        }
    }
}

