/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.io.Serializable;
import org.jbpm.pvm.internal.xml.Problem;
import org.xml.sax.SAXParseException;

public class ProblemImpl
implements Serializable,
Problem {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_WARNING = "warning";
    public static final String TYPE_XML_VALIDATION_ERROR = "xml validation error";
    public static final String TYPE_XML_VALIDATION_WARNING = "xml validation warning";
    String resource;
    String type;
    Integer line;
    Integer column;
    String msg;
    Throwable cause;

    public ProblemImpl(String msg, Exception e, String type) {
        this.type = type;
        this.msg = msg;
        this.cause = e;
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            this.resource = spe.getPublicId();
            this.line = spe.getLineNumber();
            this.column = spe.getColumnNumber();
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int columnNumber) {
        this.column = columnNumber;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int lineNumber) {
        this.line = lineNumber;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getSeverity() {
        return this.type;
    }

    public void setSeverity(String severity) {
        this.type = severity;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.type);
        text.append(": ");
        text.append(this.msg);
        text.append(" ");
        if (this.line != null || this.column != null || this.resource != null) {
            text.append("[");
            if (this.line != -1) {
                text.append("line=" + this.line + " ");
            }
            if (this.column != -1) {
                text.append("column=" + this.column + " ");
            }
            if (this.resource != null) {
                text.append("resource=" + this.resource + " ");
            }
            text.append("]");
        }
        if (this.cause != null) {
            text.append(": " + this.cause.toString());
        }
        return text.toString();
    }
}

