/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.DomBuilder;
import org.jbpm.pvm.internal.xml.Entity;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static Log log = Log.getLog((String)Parser.class.getName());
    protected SAXParserFactory saxParserFactory;
    protected String[] schemaResources;
    protected DocumentBuilderFactory documentBuilderFactory = null;
    protected Bindings bindings = null;
    protected ClassLoader classLoader = null;

    public Parser() {
        this.initialize();
    }

    public Parser(Bindings bindings) {
        this.initialize();
        this.bindings = bindings;
    }

    public Parser(Bindings bindings, Map<String, Entity> entities) {
        this.initialize();
        this.bindings = bindings;
    }

    public void initialize() {
        this.initializeSaxParserFactory();
        this.initializeDocumentBuilderFactory();
    }

    public void initializeDocumentBuilderFactory() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public void initializeSaxParserFactory() {
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setNamespaceAware(true);
    }

    protected DocumentBuilder createDocumentBuilder(Parse parse) {
        try {
            parse.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            parse.addProblem("couldn't get new document builder", e);
            return null;
        }
        parse.documentBuilder.setErrorHandler(parse);
        return parse.documentBuilder;
    }

    public void setSchemaResources(List<String> resources) {
        this.saxParserFactory.setValidating(true);
        this.saxParserFactory.setNamespaceAware(true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> schemaLocations = new ArrayList<String>(resources.size());
        for (String schemaResource : resources) {
            URL schemaUrl = classLoader.getResource(schemaResource);
            if (schemaUrl != null) {
                String schemaLocation = schemaUrl.toString();
                log.trace("schema resource found: " + schemaResource);
                schemaLocations.add(schemaLocation);
                continue;
            }
            log.debug("skipping unavailble schema resource: " + schemaResource);
        }
        this.schemaResources = schemaLocations.toArray(new String[schemaLocations.size()]);
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public Binding getBinding(Element element) {
        return this.getBinding(element, null);
    }

    public Binding getBinding(Element element, String category) {
        return this.bindings != null ? this.bindings.getBinding(element, category) : null;
    }

    public Parse createParse() {
        return new Parse(this);
    }

    public void importStream(StreamInput importedStreamInput, Element destination, Parse importingParse) {
        try {
            Parse importedParse = this.createParse();
            importedParse.setStreamSource(importedStreamInput);
            Document importedDocument = this.buildDom(importedParse);
            Element importedDocumentElement = importedDocument.getDocumentElement();
            for (Element e : XmlUtil.elements(importedDocumentElement)) {
                destination.appendChild(destination.getOwnerDocument().importNode(e, true));
            }
        }
        catch (Exception e) {
            importingParse.addProblem("couldn't import " + importedStreamInput, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Parse parse) {
        try {
            if (parse.document == null) {
                parse.document = this.buildDom(parse);
            }
            if (parse.document != null) {
                try {
                    this.parseDocument(parse.document, parse);
                }
                catch (Exception e) {
                    parse.addProblem("parsing exception: " + e.getMessage(), e);
                }
            }
        }
        finally {
            if (parse.inputStream != null) {
                try {
                    parse.inputStream.close();
                }
                catch (Exception e) {
                    parse.addProblem("couldn't close input stream", e);
                }
            }
        }
    }

    protected Document buildDom(Parse parse) {
        Document document = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            try {
                saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (Exception e) {
                log.info("couldn't set schema language property", (Throwable)e);
            }
            if (this.schemaResources != null) {
                try {
                    saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.schemaResources);
                }
                catch (Exception e) {
                    log.info("couldn't set schema source property", (Throwable)e);
                }
            }
            try {
                xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (Exception e) {
                log.info("couldn't set dynamic validation feature", (Throwable)e);
            }
            DocumentBuilder documentBuilder = this.createDocumentBuilder(parse);
            document = documentBuilder.getDOMImplementation().createDocument(null, null, null);
            parse.setDocument(document);
            DomBuilder domBuilder = new DomBuilder();
            domBuilder.setDocument(document);
            xmlReader.setContentHandler(domBuilder);
            xmlReader.setErrorHandler(parse);
            InputSource inputSource = parse.getInputSource();
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            parse.addProblem("couldn't parse xml document", e);
        }
        return document;
    }

    public Object parseDocument(Document document, Parse parse) {
        Object object;
        parse.documentObject = object = this.parseDocumentElement(document.getDocumentElement(), parse);
        return object;
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        return this.parseElement(documentElement, parse);
    }

    public Object parseElement(Element element, Parse parse) {
        return this.parseElement(element, parse, null);
    }

    public Object parseElement(Element element, Parse parse, String category) {
        Object object = null;
        String tagName = XmlUtil.getTagLocalName(element);
        Binding binding = this.getBinding(element, category);
        if (binding != null) {
            object = binding.parse(element, parse, this);
        } else if (log.isDebugEnabled()) {
            log.debug("no element parser for tag " + tagName + (category != null ? " in category " + category : " in the default category"));
        }
        return object;
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse) {
        return this.parseArgs(argElements, parse, "descriptor");
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse, String category) {
        ArrayList<ArgDescriptor> args = null;
        if (argElements != null) {
            if (argElements.size() > 0) {
                args = new ArrayList<ArgDescriptor>(argElements.size());
            }
            for (Element argElement : argElements) {
                ArgDescriptor argDescriptor = new ArgDescriptor();
                argDescriptor.setTypeName(XmlUtil.attribute(argElement, "type"));
                Element descriptorElement = XmlUtil.element(argElement);
                if (descriptorElement == null) {
                    parse.addProblem("arg must contain exactly one descriptor element out of " + this.bindings.getTagNames(category) + " as contents:" + XmlUtil.toString((Element)argElement.getParentNode()), argElement);
                } else {
                    Descriptor descriptor = (Descriptor)this.parseElement(descriptorElement, parse, category);
                    argDescriptor.setDescriptor(descriptor);
                }
                args.add(argDescriptor);
            }
        }
        return args;
    }
}

