/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServiceDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    CommandService commandService;
    List<Descriptor> interceptorDescriptors;

    @Override
    public Object construct(WireContext wireContext) {
        CommandService interceptedCommandService = this.commandService;
        if (this.interceptorDescriptors != null) {
            for (int i = this.interceptorDescriptors.size() - 1; i >= 0; --i) {
                Descriptor descriptor = this.interceptorDescriptors.get(i);
                Interceptor interceptor = (Interceptor)descriptor.construct(wireContext);
                interceptor.setNext(interceptedCommandService);
                interceptedCommandService = interceptor;
            }
        }
        return interceptedCommandService;
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return this.name == null ? CommandService.class : null;
    }

    public void addInterceptorDescriptor(Descriptor descriptor) {
        if (this.interceptorDescriptors == null) {
            this.interceptorDescriptors = new ArrayList<Descriptor>();
        }
        this.interceptorDescriptors.add(descriptor);
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

