/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jbpm.pvm.internal.script.ScriptManager;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class ScriptManagerBinding
extends WireDescriptorBinding {
    public ScriptManagerBinding() {
        super("script-manager");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String defaultLanguage;
        ObjectDescriptor descriptor = new ObjectDescriptor(ScriptManager.class);
        if (element.hasAttribute("default-expression-language")) {
            defaultLanguage = element.getAttribute("default-expression-language");
            descriptor.addInjection("defaultExpressionLanguage", new StringDescriptor(defaultLanguage));
        }
        if (element.hasAttribute("default-script-language")) {
            defaultLanguage = element.getAttribute("default-script-language");
            descriptor.addInjection("defaultScriptLanguage", new StringDescriptor(defaultLanguage));
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<Element> scriptElements = XmlUtil.elements(element, "script-language");
        for (Element scriptElement : scriptElements) {
            String languageName = null;
            if (scriptElement.hasAttribute("name")) {
                languageName = scriptElement.getAttribute("name");
            } else {
                parse.addProblem("'name' is a required attribute in element <script-language />", element);
            }
            String factoryClassName = null;
            if (scriptElement.hasAttribute("factory")) {
                factoryClassName = scriptElement.getAttribute("factory");
            } else {
                parse.addProblem("'name' is a required attribute in element <script-language />", element);
            }
            if (languageName == null || factoryClassName == null) continue;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
                ScriptEngineFactory scriptEngineFactory = (ScriptEngineFactory)factoryClass.newInstance();
                scriptEngineManager.registerEngineName(languageName, scriptEngineFactory);
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate ScriptEngineFactory " + factoryClassName, e);
            }
        }
        descriptor.addInjection("scriptEngineManager", new ProvidedObjectDescriptor(scriptEngineManager));
        return descriptor;
    }
}

