/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.binding.PropertiesBinding;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.HibernateConfigurationDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class HibernateConfigurationBinding
extends WireDescriptorBinding {
    private static final Log log = Log.getLog((String)HibernateConfigurationBinding.class.getName());
    private static final PropertiesBinding propertiesBinding = new PropertiesBinding();

    public HibernateConfigurationBinding() {
        super("hibernate-configuration");
    }

    protected HibernateConfigurationBinding(String tagName) {
        super(tagName);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        HibernateConfigurationDescriptor descriptor = new HibernateConfigurationDescriptor();
        String configurationClassName = null;
        configurationClassName = element.hasAttribute("annotations") && element.getAttribute("annotations").equalsIgnoreCase("enabled") ? "org.hibernate.cfg.AnnotationConfiguration" : Configuration.class.getName();
        descriptor.setClassName(configurationClassName);
        this.parseConfiguration(element, parse, descriptor, parser);
        return descriptor;
    }

    private void parseConfiguration(Element element, Parse parse, HibernateConfigurationDescriptor descriptor, Parser parser) {
        List<Element> configElements = XmlUtil.elements(element);
        for (Element configElement : configElements) {
            String urlText;
            String fileName;
            String resource;
            if ("cfg".equals(XmlUtil.getTagLocalName(configElement))) {
                if (configElement.hasAttribute("resource")) {
                    resource = configElement.getAttribute("resource");
                    log.trace("adding hibernate configuration resource " + resource);
                    descriptor.addCfgResource(resource);
                    continue;
                }
                if (configElement.hasAttribute("file")) {
                    fileName = configElement.getAttribute("file");
                    log.trace("adding hibernate configuration file " + fileName);
                    descriptor.addCfgFile(fileName);
                    continue;
                }
                if (configElement.hasAttribute("url")) {
                    urlText = configElement.getAttribute("url");
                    log.trace("adding hibernate configuration url " + urlText);
                    descriptor.addCfgUrl(urlText);
                    continue;
                }
                parse.addProblem("exactly 1 attribute in {resource, file, url} was expected in cfg: " + XmlUtil.toString(configElement), element);
                continue;
            }
            if ("mapping".equals(XmlUtil.getTagLocalName(configElement))) {
                if (configElement.hasAttribute("resource")) {
                    resource = configElement.getAttribute("resource");
                    log.trace("adding hibernate mapping resource " + resource);
                    descriptor.addMappingResource(resource);
                    continue;
                }
                if (configElement.hasAttribute("file")) {
                    fileName = configElement.getAttribute("file");
                    log.trace("adding hibernate mapping file " + fileName);
                    descriptor.addMappingFile(fileName);
                    continue;
                }
                if (configElement.hasAttribute("class")) {
                    String className = configElement.getAttribute("class");
                    log.trace("adding hibernate mapping class " + className);
                    descriptor.addMappingClass(className);
                    continue;
                }
                if (configElement.hasAttribute("url")) {
                    urlText = configElement.getAttribute("url");
                    log.trace("adding hibernate mapping url " + urlText);
                    descriptor.addMappingUrl(urlText);
                    continue;
                }
                parse.addProblem("exactly 1 attribute in {resource, file, class, url} was expected in mapping: " + XmlUtil.toString(element));
                continue;
            }
            if ("properties".equals(XmlUtil.getTagLocalName(configElement))) {
                PropertiesDescriptor propertiesDescriptor = (PropertiesDescriptor)propertiesBinding.parse(configElement, parse, parser);
                descriptor.setPropertiesDescriptor(propertiesDescriptor);
                continue;
            }
            if ("cache-configuration".equals(XmlUtil.getTagLocalName(configElement))) {
                List<Element> cacheElements;
                StreamInput streamSource = null;
                String cacheUsage = configElement.getAttribute("usage");
                if (!("read-only".equals(cacheUsage) || "nonstrict-read-write".equals(cacheUsage) || "read-write".equals(cacheUsage) || "transactional".equals(cacheUsage))) {
                    parse.addProblem("problem in cache-configuration: no usage attribute or illegal value: " + cacheUsage + " Possible values are {read-only, nonstrict-read-write, read-write, transactional}");
                    continue;
                }
                if (configElement.hasAttribute("file")) {
                    String fileName2 = configElement.getAttribute("file");
                    File file = new File(fileName2);
                    if (file.exists() && file.isFile()) {
                        streamSource = new FileStreamInput(file);
                    } else {
                        parse.addProblem("file " + fileName2 + " isn't a file");
                    }
                }
                if (configElement.hasAttribute("resource")) {
                    String resource2 = configElement.getAttribute("resource");
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    streamSource = new ResourceStreamInput(resource2, classLoader);
                }
                if (configElement.hasAttribute("url")) {
                    String urlText2 = configElement.getAttribute("url");
                    try {
                        URL url = new URL(urlText2);
                        streamSource = new UrlStreamInput(url);
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't open url " + urlText2, e);
                    }
                }
                if (streamSource != null) {
                    parser.importStream(streamSource, configElement, parse);
                }
                if ((cacheElements = XmlUtil.elements(configElement)) == null) continue;
                for (Element cacheElement : cacheElements) {
                    if ("class-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                        String className = cacheElement.getAttribute("class");
                        descriptor.addClassToCache(className, cacheUsage);
                        continue;
                    }
                    if ("collection-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                        String collection = cacheElement.getAttribute("collection");
                        descriptor.addCollectionToCache(collection, cacheUsage);
                        continue;
                    }
                    parse.addProblem("unknown hibernate cache configuration element " + XmlUtil.toString(configElement));
                }
                continue;
            }
            parse.addProblem("unknown hibernate configuration element " + XmlUtil.toString(configElement));
        }
    }
}

