/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.List;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.svc.AsyncCommandService;
import org.jbpm.pvm.internal.svc.DefaultCommandService;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.CommandServiceDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class CommandServiceBinding
extends WireDescriptorBinding {
    public CommandServiceBinding() {
        super("command-service");
    }

    protected CommandServiceBinding(String tagName) {
        super(tagName);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        CommandServiceDescriptor commandServiceDescriptor = new CommandServiceDescriptor();
        CommandService commandService = this.getCommandService(element, parse, parser);
        commandServiceDescriptor.setCommandService(commandService);
        List<Element> interceptorElements = XmlUtil.elements(element);
        for (Element interceptorElement : interceptorElements) {
            Descriptor interceptorDescriptor = (Descriptor)parser.parseElement(interceptorElement, parse, "interceptor");
            commandServiceDescriptor.addInterceptorDescriptor(interceptorDescriptor);
        }
        return commandServiceDescriptor;
    }

    protected CommandService getCommandService(Element element, Parse parse, Parser parser) {
        if (XmlUtil.attributeBoolean(element, "async", false, parse, Boolean.FALSE).booleanValue()) {
            AsyncCommandService asyncCommandService = new AsyncCommandService();
            if (XmlUtil.attributeBoolean(element, "propagate-auth", false, parse).booleanValue()) {
                asyncCommandService.setPropagateUserId(true);
            }
            return asyncCommandService;
        }
        return new DefaultCommandService();
    }
}

