/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jbpm.api.JbpmException;

public abstract class IoUtil {
    public static final int BUFFERSIZE = 4096;

    public static byte[] readBytes(InputStream inputStream) {
        byte[] bytes = null;
        if (inputStream == null) {
            throw new JbpmException("inputStream is null");
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IoUtil.transfer(inputStream, outputStream);
            bytes = outputStream.toByteArray();
            outputStream.close();
            return bytes;
        }
        catch (IOException e) {
            throw new JbpmException("couldn't read bytes from inputStream", (Throwable)e);
        }
    }

    public static int transfer(InputStream in, OutputStream out) {
        int total = 0;
        byte[] buffer = new byte[4096];
        try {
            int bytesRead = in.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                total += bytesRead;
                bytesRead = in.read(buffer);
            }
            return total;
        }
        catch (IOException e) {
            throw new JbpmException("couldn't write bytes to output stream", (Throwable)e);
        }
    }
}

