/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.tx.DeserializedObject;
import org.jbpm.pvm.internal.tx.Transaction;
import org.jbpm.pvm.internal.type.Converter;
import org.jbpm.pvm.internal.type.Variable;
import org.jbpm.pvm.internal.type.variable.BlobVariable;

public class SerializableToBytesConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    public boolean supports(Object value, ScopeInstanceImpl scopeInstance, Variable variable) {
        if (value == null) {
            return true;
        }
        return Serializable.class.isAssignableFrom(value.getClass());
    }

    public Object convert(Object o, ScopeInstanceImpl scopeInstance, Variable variable) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new JbpmException("couldn't serialize '" + o + "'", (Throwable)e);
        }
        return bytes;
    }

    public Object revert(Object o, ScopeInstanceImpl scopeInstance, Variable variable) {
        byte[] bytes = (byte[])o;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            Transaction transaction = EnvironmentImpl.getFromCurrent(Transaction.class, false);
            if (transaction != null) {
                transaction.registerDeserializedObject(new DeserializedObject(object, scopeInstance, (BlobVariable)variable));
            }
            return object;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't deserialize object", (Throwable)e);
        }
    }
}

