/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type;

import java.io.Serializable;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.HistorySession;
import org.jbpm.pvm.internal.history.events.VariableUpdate;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.type.Converter;
import org.jbpm.pvm.internal.type.Type;

public abstract class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid = -1L;
    protected int dbversion = 0;
    protected String key = null;
    protected Converter converter = null;
    protected String textValue = null;
    protected boolean isHistoryEnabled = false;
    protected ExecutionImpl execution;
    protected TaskImpl task;

    public abstract boolean isStorable(Object var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public boolean supports(Object value, ScopeInstanceImpl scopeInstance) {
        if (this.converter != null) {
            return this.converter.supports(value, scopeInstance, this);
        }
        return this.isStorable(value);
    }

    public void setValue(Object value, ScopeInstanceImpl scopeInstance) {
        if (this.converter != null) {
            if (!this.converter.supports(value, scopeInstance, this)) {
                throw new JbpmException("the converter '" + this.converter.getClass().getName() + "' in variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
            }
            value = this.converter.convert(value, scopeInstance, this);
        }
        if (value != null && !this.isStorable(value)) {
            throw new JbpmException("variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
        }
        this.setObject(value);
        HistorySession historySession = EnvironmentImpl.getFromCurrent(HistorySession.class, false);
        if (this.isHistoryEnabled && historySession != null) {
            HistoryEvent.fire(new VariableUpdate(this));
        }
    }

    public Object getValue(ScopeInstanceImpl scopeInstance) {
        Object value = this.getObject();
        if (value != null && this.converter != null) {
            value = this.converter.revert(value, scopeInstance, this);
        }
        return value;
    }

    public String toString() {
        return "${" + this.key + "}";
    }

    public Type getType() {
        Type type = new Type();
        type.setConverter(this.converter);
        type.setVariableClass(this.getClass());
        return type;
    }

    public ExecutionImpl getProcessInstance() {
        return this.execution != null ? this.execution.getProcessInstance() : null;
    }

    public String getKey() {
        return this.key;
    }

    public long getDbid() {
        return this.dbid;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public ExecutionImpl getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionImpl execution) {
        this.execution = execution;
    }

    public TaskImpl getTask() {
        return this.task;
    }

    public void setTask(TaskImpl task) {
        this.task = task;
    }

    public boolean isHistoryEnabled() {
        return this.isHistoryEnabled;
    }

    public void setHistoryEnabled(boolean isHistoryEnabled) {
        this.isHistoryEnabled = isHistoryEnabled;
    }

    public void setDbid(long dbid) {
        this.dbid = dbid;
    }
}

