/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.tx.StandardTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransactionInterceptor
extends Interceptor {
    private static final Log log = Log.getLog((String)StandardTransactionInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment == null) {
            throw new JbpmException("no environment for managing hibernate transaction");
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        if (standardTransaction == null) {
            throw new JbpmException("no standard-transaction in environment");
        }
        standardTransaction.begin();
        try {
            T t = this.next.execute(command);
            return t;
        }
        catch (RuntimeException e) {
            standardTransaction.setRollbackOnly();
            throw e;
        }
        finally {
            standardTransaction.complete();
        }
    }
}

