/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.svc.Interceptor;
import org.jbpm.pvm.internal.svc.Policy;
import org.jbpm.pvm.internal.tx.SpringCommandCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTransactionInterceptor
extends Interceptor {
    private static final Log log = Log.getLog((String)SpringTransactionInterceptor.class.getName());
    protected int springPropagationBehaviour = 0;
    private String transactionManagerName;

    @Override
    public <T> T execute(Command<T> command) {
        AbstractPlatformTransactionManager platformTransactionManager = (AbstractPlatformTransactionManager)this.resolveTransactionManager();
        TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)platformTransactionManager);
        template.setPropagationBehavior(this.springPropagationBehaviour);
        return (T)template.execute((TransactionCallback)new SpringCommandCallback(this.next, command));
    }

    private PlatformTransactionManager resolveTransactionManager() {
        if (this.transactionManagerName != null && this.transactionManagerName.length() > 0) {
            return (PlatformTransactionManager)EnvironmentImpl.getFromCurrent(this.transactionManagerName);
        }
        return EnvironmentImpl.getFromCurrent(PlatformTransactionManager.class);
    }

    public void setPolicy(Policy policy) {
        this.springPropagationBehaviour = policy == Policy.REQUIRES_NEW ? 3 : 0;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }
}

