/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import java.util.Arrays;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.type.converter.SerializableToBytesConverter;
import org.jbpm.pvm.internal.type.variable.BlobVariable;

public class DeserializedObject {
    private static final SerializableToBytesConverter serializableToBytesConverter = new SerializableToBytesConverter();
    Object deserializedObject;
    ScopeInstanceImpl scopeInstance;
    BlobVariable blobVariable;

    public DeserializedObject(Object deserializedObject, ScopeInstanceImpl scopeInstance, BlobVariable blobVariable) {
        this.deserializedObject = deserializedObject;
        this.scopeInstance = scopeInstance;
        this.blobVariable = blobVariable;
    }

    public void flush() {
        String variableName = this.blobVariable.getKey();
        Object currentValue = this.scopeInstance.getVariable(variableName);
        if (currentValue != null && currentValue == this.deserializedObject) {
            byte[] newBytes = (byte[])serializableToBytesConverter.convert(currentValue, null, null);
            byte[] persistedBytes = this.blobVariable.getLob().extractBytes();
            if (!Arrays.equals(persistedBytes, newBytes)) {
                this.blobVariable.setValue(this.deserializedObject, this.scopeInstance);
            }
        }
    }
}

