/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.TaskService;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.cmd.AddParticipationCmd;
import org.jbpm.pvm.internal.cmd.AddReplyCommentCmd;
import org.jbpm.pvm.internal.cmd.AddTaskCommentCmd;
import org.jbpm.pvm.internal.cmd.AssignTaskCmd;
import org.jbpm.pvm.internal.cmd.CompleteTaskCmd;
import org.jbpm.pvm.internal.cmd.CompositeCmd;
import org.jbpm.pvm.internal.cmd.CreateTaskQueryCmd;
import org.jbpm.pvm.internal.cmd.DeleteCommentCmd;
import org.jbpm.pvm.internal.cmd.DeleteTaskCmd;
import org.jbpm.pvm.internal.cmd.GetOutcomes;
import org.jbpm.pvm.internal.cmd.GetParticipantsCmd;
import org.jbpm.pvm.internal.cmd.GetSubTasksCmd;
import org.jbpm.pvm.internal.cmd.GetTaskCmd;
import org.jbpm.pvm.internal.cmd.GetTaskCommentsCmd;
import org.jbpm.pvm.internal.cmd.GetTaskVariableNamesCmd;
import org.jbpm.pvm.internal.cmd.GetTaskVariablesCmd;
import org.jbpm.pvm.internal.cmd.NewTaskCmd;
import org.jbpm.pvm.internal.cmd.RemoveParticipantCmd;
import org.jbpm.pvm.internal.cmd.SaveTaskCmd;
import org.jbpm.pvm.internal.cmd.SetTaskVariablesCmd;
import org.jbpm.pvm.internal.query.TaskQueryImpl;
import org.jbpm.pvm.internal.svc.AbstractServiceImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskServiceImpl
extends AbstractServiceImpl
implements TaskService {
    public Task newTask() {
        return this.commandService.execute(new NewTaskCmd(null));
    }

    public Task getTask(String taskId) {
        return this.commandService.execute(new GetTaskCmd(taskId));
    }

    public String saveTask(Task task) {
        return this.commandService.execute(new SaveTaskCmd((TaskImpl)task));
    }

    public void deleteTask(String taskId) {
        this.commandService.execute(new DeleteTaskCmd(taskId));
    }

    public void deleteTask(String taskId, String reason) {
        this.commandService.execute(new DeleteTaskCmd(taskId, reason));
    }

    public void deleteTaskCascade(String taskId) {
        this.commandService.execute(new DeleteTaskCmd(taskId, true));
    }

    public void completeTask(String taskId) {
        this.commandService.execute(new CompleteTaskCmd(taskId));
    }

    public void completeTask(String taskId, Map<String, Object> variables) {
        this.completeTask(taskId, null, variables);
    }

    public void completeTask(String taskId, String outcome) {
        this.commandService.execute(new CompleteTaskCmd(taskId, outcome));
    }

    public void completeTask(String taskId, String outcome, Map<String, Object> variables) {
        SetTaskVariablesCmd setTaskVariablesCmd = new SetTaskVariablesCmd(taskId);
        setTaskVariablesCmd.setVariables(variables);
        CompositeCmd compositeCmd = new CompositeCmd();
        compositeCmd.addCommand(setTaskVariablesCmd);
        compositeCmd.addCommand(new CompleteTaskCmd(taskId, outcome));
        this.commandService.execute(compositeCmd);
    }

    public void addTaskParticipatingUser(String taskId, String userId, String participation) {
        this.commandService.execute(new AddParticipationCmd(taskId, null, userId, null, participation));
    }

    public void addTaskParticipatingGroup(String taskId, String groupId, String participation) {
        this.commandService.execute(new AddParticipationCmd(taskId, null, null, groupId, participation));
    }

    public List<Participation> getTaskParticipations(String taskId) {
        return this.commandService.execute(new GetParticipantsCmd(taskId, null));
    }

    public void removeTaskParticipatingUser(String taskId, String userId, String participation) {
        this.commandService.execute(new RemoveParticipantCmd(taskId, null, userId, null, participation));
    }

    public void removeTaskParticipatingGroup(String taskId, String groupId, String participation) {
        this.commandService.execute(new RemoveParticipantCmd(taskId, null, null, groupId, participation));
    }

    public List<Task> findPersonalTasks(String userId) {
        return this.createTaskQuery().assignee(userId).orderDesc("priority").list();
    }

    public List<Task> findGroupTasks(String userId) {
        return this.createTaskQuery().candidate(userId).orderDesc("priority").list();
    }

    public TaskQuery createTaskQuery() {
        TaskQueryImpl query = this.commandService.execute(new CreateTaskQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    public List<Task> getSubTasks(String taskId) {
        return this.commandService.execute(new GetSubTasksCmd(taskId));
    }

    public Task newTask(String parentTaskId) {
        return this.commandService.execute(new NewTaskCmd(parentTaskId));
    }

    public HistoryComment addTaskComment(String taskId, String message) {
        return this.commandService.execute(new AddTaskCommentCmd(taskId, message));
    }

    public List<HistoryComment> getTaskComments(String taskId) {
        return this.commandService.execute(new GetTaskCommentsCmd(taskId));
    }

    public void deleteComment(String commentId) {
        this.commandService.execute(new DeleteCommentCmd(commentId));
    }

    public HistoryComment addReplyComment(String commentId, String message) {
        return this.commandService.execute(new AddReplyCommentCmd(commentId, message));
    }

    public void assignTask(String taskId, String userId) {
        this.commandService.execute(new AssignTaskCmd(taskId, userId));
    }

    public void takeTask(String taskId, String userId) {
        this.commandService.execute(new AssignTaskCmd(taskId, userId, true));
    }

    public Object getVariable(String taskId, String variableName) {
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add(variableName);
        GetTaskVariablesCmd cmd = new GetTaskVariablesCmd(taskId, variableNames);
        Map<String, Object> variables = this.commandService.execute(cmd);
        return variables.get(variableName);
    }

    public Set<String> getVariableNames(String taskDbid) {
        return this.commandService.execute(new GetTaskVariableNamesCmd(taskDbid));
    }

    public Map<String, Object> getVariables(String taskDbid, Set<String> variableNames) {
        return this.commandService.execute(new GetTaskVariablesCmd(taskDbid, variableNames));
    }

    public void setVariables(String taskDbid, Map<String, Object> variables) {
        SetTaskVariablesCmd cmd = new SetTaskVariablesCmd(taskDbid);
        cmd.setVariables(variables);
        this.commandService.execute(cmd);
    }

    public Set<String> getOutcomes(String taskId) {
        return this.commandService.execute(new GetOutcomes(taskId));
    }
}

