/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.script;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.jbpm.pvm.internal.script.XPathScriptEngineFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory factory;
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    public static final String XPATH_RESULT_TYPE = "com.sun.script.xpath.resultType";
    public static final String XPATH_INPUT_SRC = "com.sun.script.xpath.inputSource";
    public static final String XMLNS_COLON = "xmlns:";
    public static final String XPATH_CONTEXT_PREFIX = "context";
    public static final String XPATH_CONTEXT_URI = "http://www.sun.com/java/jsr223/xpath/context";
    private Document objectData;

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        XPathExpression expr = this.compileXPath(script, this.context);
        return new XPathCompiledScript(expr);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        XPathExpression expr = this.compileXPath(str, ctx);
        return this.evalXPath(expr, ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        XPathScriptEngine xPathScriptEngine = this;
        synchronized (xPathScriptEngine) {
            if (this.factory == null) {
                this.factory = new XPathScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findVariable(QName qname, ScriptContext ctx) {
        int scope;
        ScriptContext scriptContext;
        String name;
        if (XPATH_CONTEXT_URI.equals(qname.getNamespaceURI())) {
            name = qname.getLocalPart();
            scriptContext = ctx;
            synchronized (scriptContext) {
                scope = ctx.getAttributesScope(name);
                if (scope != -1) {
                    return ctx.getAttribute(name, scope);
                }
            }
        }
        name = qname.getPrefix() == null || "".equals(qname.getPrefix()) ? qname.getLocalPart() : qname.getPrefix() + ":" + qname.getLocalPart();
        scriptContext = ctx;
        synchronized (scriptContext) {
            scope = ctx.getAttributesScope(name);
            if (scope != -1) {
                return ctx.getAttribute(name, scope);
            }
        }
        return null;
    }

    private static void collectNamespaces(Map<String, String> map, Bindings scope) {
        for (String key : scope.keySet()) {
            String tmp;
            if (!key.startsWith(XMLNS_COLON)) continue;
            Object uri = scope.get(key);
            String prefix = key.substring(XMLNS_COLON.length());
            if (!(uri instanceof String) || (tmp = (String)uri).length() == 0) continue;
            map.put(prefix, tmp);
        }
    }

    private static NamespaceContext makeNamespaceContext(ScriptContext ctx) {
        final HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int scope : ctx.getScopes()) {
            Bindings bind = ctx.getBindings(scope);
            if (bind == null) continue;
        }
        Object def = ctx.getAttribute("xmlns");
        if (def instanceof String) {
            namespaces.put("", (String)def);
        }
        namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        namespaces.put(XPATH_CONTEXT_PREFIX, XPATH_CONTEXT_URI);
        return new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException();
                }
                String uri = (String)namespaces.get(prefix);
                if (uri == null) {
                    return "";
                }
                return uri;
            }

            public String getPrefix(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException();
                }
                for (String prefix : namespaces.keySet()) {
                    String uri = (String)namespaces.get(prefix);
                    if (!namespaceURI.equals(uri)) continue;
                    return prefix;
                }
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException();
                }
                ArrayList<String> list = new ArrayList<String>();
                for (String prefix : namespaces.keySet()) {
                    String uri = (String)namespaces.get(prefix);
                    if (!namespaceURI.equals(uri)) continue;
                    list.add(prefix);
                }
                return Collections.unmodifiableList(list).iterator();
            }
        };
    }

    private static XPathFunction makeXPathFunction(final Constructor ctr, int arity) {
        if (ctr.getParameterTypes().length != arity) {
            return null;
        }
        return new XPathFunction(){

            public Object evaluate(List args) {
                try {
                    return ctr.newInstance(args.toArray());
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
            }
        };
    }

    private static XPathFunction makeXPathFunction(final Method method, int arity) {
        int modifiers = method.getModifiers();
        int numArgs = method.getParameterTypes().length;
        if (Modifier.isStatic(modifiers) && numArgs == arity) {
            return new XPathFunction(){

                public Object evaluate(List args) {
                    try {
                        return method.invoke(null, args.toArray());
                    }
                    catch (Exception exp) {
                        throw new RuntimeException(exp);
                    }
                }
            };
        }
        if (numArgs + 1 == arity) {
            return new XPathFunction(){

                public Object evaluate(List args) {
                    List tmp = args.subList(1, args.size());
                    try {
                        return method.invoke(args.get(0), tmp.toArray());
                    }
                    catch (Exception exp) {
                        throw new RuntimeException(exp);
                    }
                }
            };
        }
        return null;
    }

    private static XPathFunction makeXPathFunction(final String funcName, final Invocable invocable) {
        return new XPathFunction(){

            public Object evaluate(List args) {
                try {
                    return invocable.invokeFunction(funcName, args.toArray());
                }
                catch (Exception exp) {
                    throw new RuntimeException(exp);
                }
            }
        };
    }

    private static XPathFunction makeXPathFunction(QName qname, Object obj, int arity) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof XPathFunction) {
            return (XPathFunction)obj;
        }
        if (obj instanceof Method) {
            return XPathScriptEngine.makeXPathFunction((Method)obj, arity);
        }
        if (obj instanceof Constructor) {
            return XPathScriptEngine.makeXPathFunction((Constructor)obj, arity);
        }
        if (obj instanceof Invocable) {
            return XPathScriptEngine.makeXPathFunction(qname.getLocalPart(), (Invocable)obj);
        }
        return null;
    }

    private XPathExpression compileXPath(String str, final ScriptContext ctx) throws ScriptException {
        ctx.setAttribute(XPATH_CONTEXT_PREFIX, ctx, 100);
        try {
            int begin;
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setXPathVariableResolver(new XPathVariableResolver(){

                public Object resolveVariable(QName qname) {
                    return XPathScriptEngine.findVariable(qname, ctx);
                }
            });
            xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

                public XPathFunction resolveFunction(QName qname, int arity) {
                    Object obj = XPathScriptEngine.findVariable(qname, ctx);
                    return XPathScriptEngine.makeXPathFunction(qname, obj, arity);
                }
            });
            xpath.setNamespaceContext(XPathScriptEngine.makeNamespaceContext(ctx));
            int n = begin = str.indexOf("getObjectData") > -1 ? 14 : 0;
            if (begin > 0) {
                String objectDataRef = str.substring(begin + 1, str.indexOf(")") - 1);
                this.objectData = (Document)ctx.getAttribute(objectDataRef);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                DOMSource xmlSource = new DOMSource(this.objectData);
                StreamResult outputTarget = new StreamResult(outputStream);
                TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
                ctx.setReader(new InputStreamReader(is));
                str = str.substring(str.indexOf(")") + 1);
            }
            XPathExpression xpe = xpath.compile(str);
            return xpe;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getVariable(ScriptContext ctx, String name) {
        ScriptContext scriptContext = ctx;
        synchronized (scriptContext) {
            int scope = ctx.getAttributesScope(name);
            if (scope != -1) {
                return ctx.getAttribute(name, scope);
            }
        }
        return null;
    }

    private Object evalXPath(XPathExpression expr, ScriptContext ctx) throws ScriptException {
        try {
            Object resultType = this.getVariable(ctx, XPATH_RESULT_TYPE);
            Object input = this.getVariable(ctx, XPATH_INPUT_SRC);
            InputSource src = input == null ? new InputSource(ctx.getReader()) : (input instanceof InputSource ? (InputSource)input : (input instanceof String ? new InputSource((String)input) : (input instanceof Reader ? new InputSource((Reader)input) : (input instanceof InputStream ? new InputSource((InputStream)input) : null))));
            resultType = XPathConstants.BOOLEAN;
            if (resultType instanceof QName) {
                return src != null ? expr.evaluate(src, (QName)resultType) : expr.evaluate(input, (QName)resultType);
            }
            return src != null ? expr.evaluate(src) : expr.evaluate(input);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private class XPathCompiledScript
    extends CompiledScript {
        private XPathExpression expr;

        XPathCompiledScript(XPathExpression expr) {
            this.expr = expr;
        }

        public ScriptEngine getEngine() {
            return XPathScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return XPathScriptEngine.this.evalXPath(this.expr, ctx);
        }
    }
}

