/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.jbpm.api.DeploymentQuery;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.model.ActivityCoordinates;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.cmd.CreateDeploymentQueryCmd;
import org.jbpm.pvm.internal.cmd.CreateProcessDefinitionQueryCmd;
import org.jbpm.pvm.internal.cmd.DeleteDeploymentCmd;
import org.jbpm.pvm.internal.cmd.GetActivityCoordinatesCmd;
import org.jbpm.pvm.internal.cmd.GetDeploymentResourceNamesCmd;
import org.jbpm.pvm.internal.cmd.GetResourceAsStreamCmd;
import org.jbpm.pvm.internal.cmd.GetStartActivityNamesCmd;
import org.jbpm.pvm.internal.cmd.GetStartFormResourceNameCmd;
import org.jbpm.pvm.internal.cmd.ResumeDeploymentCmd;
import org.jbpm.pvm.internal.cmd.SuspendDeploymentCmd;
import org.jbpm.pvm.internal.cmd.UpdateDeploymentResourceCmd;
import org.jbpm.pvm.internal.query.DeploymentQueryImpl;
import org.jbpm.pvm.internal.query.ProcessDefinitionQueryImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
implements RepositoryService {
    CommandService commandService;

    public NewDeployment createDeployment() {
        return new DeploymentImpl(this.commandService);
    }

    public void suspendDeployment(String deploymentId) {
        this.commandService.execute(new SuspendDeploymentCmd(deploymentId));
    }

    public void resumeDeployment(String deploymentId) {
        this.commandService.execute(new ResumeDeploymentCmd(deploymentId));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandService.execute(new DeleteDeploymentCmd(deploymentId));
    }

    public void deleteDeploymentCascade(String deploymentId) {
        this.commandService.execute(new DeleteDeploymentCmd(deploymentId, true));
    }

    public Set<String> getResourceNames(String deploymentId) {
        return this.commandService.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resource) {
        byte[] bytes = this.commandService.execute(new GetResourceAsStreamCmd(deploymentId, resource));
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public ProcessDefinitionQuery createProcessDefinitionQuery() {
        ProcessDefinitionQueryImpl query = this.commandService.execute(new CreateProcessDefinitionQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    public DeploymentQuery createDeploymentQuery() {
        DeploymentQueryImpl query = this.commandService.execute(new CreateDeploymentQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    public ActivityCoordinates getActivityCoordinates(String processDefinitionId, String activityName) {
        return this.commandService.execute(new GetActivityCoordinatesCmd(processDefinitionId, activityName));
    }

    public List<String> getStartActivityNames(String processDefinitionId) {
        return this.commandService.execute(new GetStartActivityNamesCmd(processDefinitionId));
    }

    public String getStartFormResourceName(String processDefinitionId, String activityName) {
        return this.commandService.execute(new GetStartFormResourceNameCmd(processDefinitionId, activityName));
    }

    public void updateDeploymentResource(String deploymentId, String resourceName, InputStream inputStream) {
        this.commandService.execute(new UpdateDeploymentResourceCmd(deploymentId, resourceName, inputStream));
    }
}

