/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.util.IoUtil;

public class DeploymentClassLoader
extends ClassLoader {
    private String deploymentId = null;

    public DeploymentClassLoader(ClassLoader parent, String deploymentId) {
        super(parent);
        this.deploymentId = deploymentId;
    }

    public URL findResource(String name) {
        URL url = null;
        byte[] bytes = this.getDeployment().getBytes(name);
        if (bytes != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            try {
                url = new URL(null, "jbpm://" + this.deploymentId + "/" + name, new BytesUrlStreamHandler(inputStream));
            }
            catch (MalformedURLException e) {
                throw new JbpmException("couldn't create url", (Throwable)e);
            }
        }
        return url;
    }

    protected DeploymentImpl getDeployment() {
        RepositorySession repositorySession = EnvironmentImpl.getFromCurrent(RepositorySession.class);
        return repositorySession.getDeployment(this.deploymentId);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        String fileName = name.replace('.', '/') + ".class";
        byte[] bytes = this.getDeployment().getBytes(fileName);
        if (bytes != null) {
            try {
                String packageName;
                Package classPackage;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                byte[] classBytes = IoUtil.readBytes(inputStream);
                clazz = this.defineClass(name, classBytes, 0, classBytes.length);
                int packageIndex = name.lastIndexOf(46);
                if (packageIndex != -1 && (classPackage = this.getPackage(packageName = name.substring(0, packageIndex))) == null) {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
            }
            catch (JbpmException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("class '" + name + "' could not be found in deployment " + this.deploymentId);
        }
        return clazz;
    }

    public static class BytesUrlConnection
    extends URLConnection {
        InputStream inputStream;

        public BytesUrlConnection(InputStream inputStream, URL url) {
            super(url);
            this.inputStream = inputStream;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }
    }

    public static class BytesUrlStreamHandler
    extends URLStreamHandler {
        InputStream inputStream;

        public BytesUrlStreamHandler(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new BytesUrlConnection(this.inputStream, u);
        }
    }
}

