/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.history.HistoryProcessInstanceQuery;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryProcessInstanceQueryImpl
extends AbstractQuery
implements HistoryProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String state;
    protected String processInstanceId;
    protected String processInstanceKey;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.count) {
            hql.append("count(hpi) ");
        } else {
            hql.append("hpi ");
        }
        hql.append("from ");
        hql.append(HistoryProcessInstanceImpl.class.getName());
        hql.append(" as hpi ");
        if (this.processInstanceId != null) {
            this.appendWhereClause(" hpi.processInstanceId = '" + this.processInstanceId + "' ", hql);
        }
        if (this.processDefinitionId != null) {
            this.appendWhereClause(" hpi.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.state != null) {
            this.appendWhereClause(" hpi.state = '" + this.state + "' ", hql);
        }
        if (this.processInstanceKey != null) {
            this.appendWhereClause(" hpi.key = '" + this.processInstanceKey + "'", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
    }

    public List<HistoryProcessInstance> list() {
        return this.untypedList();
    }

    public HistoryProcessInstance uniqueResult() {
        return (HistoryProcessInstance)this.untypedUniqueResult();
    }

    public HistoryProcessInstanceQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoryProcessInstanceQuery orderAsc(String property) {
        this.addOrderByClause("hpi." + property + " asc");
        return this;
    }

    public HistoryProcessInstanceQuery orderDesc(String property) {
        this.addOrderByClause("hpi." + property + " desc");
        return this;
    }

    public HistoryProcessInstanceQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    public HistoryProcessInstanceQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public HistoryProcessInstanceQuery processInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public HistoryProcessInstanceQuery state(String state) {
        this.state = state;
        return this;
    }
}

