/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.history.HistoryDetail;
import org.jbpm.api.history.HistoryDetailQuery;
import org.jbpm.pvm.internal.history.model.HistoryCommentImpl;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDetailQueryImpl
extends AbstractQuery
implements HistoryDetailQuery {
    protected Class<?> type = HistoryDetailImpl.class;
    protected Date timeBefore;
    protected Date timeAfter;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String taskId;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select hd ");
        hql.append("from ");
        hql.append(this.type.getName());
        hql.append(" as hd ");
        if (this.taskId != null) {
            this.appendWhereClause(" hd.historyTask.dbid = " + this.taskId + " ", hql);
        }
        if (this.processInstanceId != null) {
            this.appendWhereClause(" hd.historyProcessInstance.processInstanceId = '" + this.processInstanceId + "' ", hql);
        }
        if (this.activityInstanceId != null) {
            this.appendWhereClause(" hd.historyActivityInstance.dbid = " + this.activityInstanceId + " ", hql);
        }
        if (this.timeBefore != null) {
            this.appendWhereClause(" hd.time < :timeBefore ", hql);
        }
        if (this.timeAfter != null) {
            this.appendWhereClause(" hd.time > :timeAfter ", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.timeAfter != null) {
            query.setTime("timeAfter", this.timeAfter);
        }
        if (this.timeBefore != null) {
            query.setTime("timeBefore", this.timeBefore);
        }
    }

    public List<HistoryDetail> list() {
        return this.untypedList();
    }

    public HistoryDetail uniqueResult() {
        return (HistoryDetail)this.untypedUniqueResult();
    }

    public HistoryDetailQuery taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public HistoryDetailQuery orderAsc(String property) {
        this.addOrderByClause("hd." + property + " asc");
        return this;
    }

    public HistoryDetailQuery orderDesc(String property) {
        this.addOrderByClause("hd." + property + " desc");
        return this;
    }

    public HistoryDetailQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    public HistoryDetailQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public HistoryDetailQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoryDetailQuery comments() {
        this.type = HistoryCommentImpl.class;
        return this;
    }

    public HistoryDetailQuery timeAfter(Date timeAfter) {
        this.timeAfter = timeAfter;
        return this;
    }

    public HistoryDetailQuery timeBefore(Date timeBefore) {
        this.timeBefore = timeBefore;
        return this;
    }
}

