/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvgDurationPerActivityQueryCmd
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public AvgDurationPerActivityQueryCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public Object execute(Environment environment) throws Exception {
        Session session = (Session)environment.get(Session.class);
        Query query = session.createQuery("select distinct hai.activityName from " + HistoryActivityInstanceImpl.class.getName() + " as hai " + "where hai.historyProcessInstance.processDefinitionId = :processDefinitionId");
        query.setString("processDefinitionId", this.processDefinitionId);
        HashMap<String, Long> avgDuration = new HashMap<String, Long>();
        List activityNames = query.list();
        for (String activityName : activityNames) {
            query = session.createQuery("select avg(hai.duration) from " + HistoryActivityInstanceImpl.class.getName() + " as hai " + "where hai.historyProcessInstance.processDefinitionId = :processDefinitionId " + "  and hai.activityName = :activityName");
            query.setString("processDefinitionId", this.processDefinitionId);
            query.setString("activityName", activityName);
            Number number = (Number)query.uniqueResult();
            avgDuration.put(activityName, new Long(number.longValue()));
        }
        return avgDuration;
    }
}

